/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.extractor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.hslf.record.TextHeaderAtom;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public class QuickButCruddyTextExtractor {
    private POIFSFileSystem fs;
    private InputStream is;
    private byte[] pptContents;

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("Useage:");
            System.err.println("\tQuickButCruddyTextExtractor <file>");
            System.exit(1);
        }
        String file = args[0];
        QuickButCruddyTextExtractor ppe = new QuickButCruddyTextExtractor(file);
        System.out.println(ppe.getTextAsString());
        ppe.close();
    }

    public QuickButCruddyTextExtractor(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public QuickButCruddyTextExtractor(InputStream iStream) throws IOException {
        this(new POIFSFileSystem(iStream));
        this.is = iStream;
    }

    public QuickButCruddyTextExtractor(POIFSFileSystem poifs) throws IOException {
        this.fs = poifs;
        DocumentEntry docProps = (DocumentEntry)this.fs.getRoot().getEntry("PowerPoint Document");
        this.pptContents = new byte[docProps.getSize()];
        this.fs.createDocumentInputStream("PowerPoint Document").read(this.pptContents);
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        this.fs = null;
    }

    public String getTextAsString() {
        StringBuffer ret = new StringBuffer();
        Vector textV = this.getTextAsVector();
        for (int i = 0; i < textV.size(); ++i) {
            String text = (String)textV.get(i);
            ret.append(text);
            if (text.endsWith("\n")) continue;
            ret.append('\n');
        }
        return ret.toString();
    }

    public Vector getTextAsVector() {
        Vector textV = new Vector();
        int walkPos = 0;
        while (walkPos != -1) {
            int newPos;
            walkPos = newPos = this.findTextRecords(walkPos, textV);
        }
        return textV;
    }

    public int findTextRecords(int startPos, Vector textV) {
        int newPos;
        int len = (int)LittleEndian.getUInt((byte[])this.pptContents, (int)(startPos + 4));
        byte opt = this.pptContents[startPos];
        int container = opt & 0xF;
        if (container == 15) {
            return startPos + 8;
        }
        long type = LittleEndian.getUShort((byte[])this.pptContents, (int)(startPos + 2));
        TextRun trun = null;
        if (type == 4008L) {
            TextBytesAtom tba = (TextBytesAtom)Record.createRecordForType(type, this.pptContents, startPos, len + 8);
            trun = new TextRun((TextHeaderAtom)null, tba);
        }
        if (type == 4000L) {
            TextCharsAtom tca = (TextCharsAtom)Record.createRecordForType(type, this.pptContents, startPos, len + 8);
            trun = new TextRun((TextHeaderAtom)null, tca);
        }
        if (trun != null) {
            textV.add(trun.getText());
        }
        if ((newPos = startPos + 8 + len) > this.pptContents.length - 8) {
            newPos = -1;
        }
        return newPos;
    }
}

