/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.PositionDependentRecordContainer;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.SlideAtom;

public class Slide
extends PositionDependentRecordContainer {
    private Record[] _children;
    private byte[] _header = new byte[8];
    private static long _type = 1006L;
    private SlideAtom slideAtom;
    private PPDrawing ppDrawing;

    public SlideAtom getSlideAtom() {
        return this.slideAtom;
    }

    public PPDrawing getPPDrawing() {
        return this.ppDrawing;
    }

    protected Slide(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof SlideAtom) {
                this.slideAtom = (SlideAtom)this._children[i];
            }
            if (!(this._children[i] instanceof PPDrawing)) continue;
            this.ppDrawing = (PPDrawing)this._children[i];
        }
    }

    public long getRecordType() {
        return _type;
    }

    public Record[] getChildRecords() {
        return this._children;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }
}

