/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.portal.PortalTemplateConfigOption;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalBrowser;
import org.exoplatform.portal.webui.skin.SkinService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.Param;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputItemSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.organization.UIListPermissionSelector;
import org.exoplatform.webui.organization.UIPermissionSelector;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="CreatePortal", lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", initParams={@ParamConfig(name="PortalTemplateConfigOption", value="app:/WEB-INF/conf/uiconf/portal/webui/portal/PortalTemplateConfigOption.groovy")}, events={@EventConfig(name="Save", listeners={CreateActionListener.class}), @EventConfig(listeners={SelectItemOptionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIFormInputSet.class, id="PermissionSetting", template="system:/groovy/webui/core/UITabSelector.gtmpl")})
public class UIPortalForm
extends UIFormTabPane {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SKIN = "skin";
    private static final String FIELD_LOCALE = "locale";
    private List<SelectItemOption<String>> languages = new ArrayList<SelectItemOption<String>>();

    public UIPortalForm(InitParams initParams) throws Exception {
        super("UIPortalForm");
        UIFormInputItemSelector uiTemplateInput = new UIFormInputItemSelector("PortalTemplate", null);
        this.addUIFormInput((UIFormInput)uiTemplateInput);
        this.setSelectedTab(uiTemplateInput.getId());
        this.createDefaultItem();
        UIFormInputSet uiPortalSetting = (UIFormInputSet)this.getChildById("PortalSetting");
        UIFormStringInput uiNameInput = uiPortalSetting.getUIStringInput(FIELD_NAME);
        uiNameInput.setEditable(true);
        this.setActions(new String[]{"Save", "Close"});
        if (initParams == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Param param = initParams.getParam("PortalTemplateConfigOption");
        List portalTemplates = (List)param.getMapGroovyObject(context);
        for (SelectItemCategory itemCategory : portalTemplates) {
            uiTemplateInput.getItemCategories().add(itemCategory);
        }
        if (uiTemplateInput.getSelectedItemOption() == null) {
            ((SelectItemCategory)uiTemplateInput.getItemCategories().get(0)).setSelected(true);
        }
    }

    public UIPortalForm() throws Exception {
        super("UIPortalForm");
        this.createDefaultItem();
        this.setSelectedTab("PortalSetting");
        this.invokeGetBindingBean((Object)Util.getUIPortal());
    }

    private void createDefaultItem() throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        LocaleConfigService localeConfigService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        Collection listLocaleConfig = localeConfigService.getLocalConfigs();
        Locale currentLocate = ((UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class)).getLocale();
        for (LocaleConfig localeConfig : listLocaleConfig) {
            Locale locale = localeConfig.getLocale();
            SelectItemOption option = new SelectItemOption(localeConfig.getLocale().getDisplayName(), (Object)localeConfig.getLanguage());
            if (locale.getDisplayName().equalsIgnoreCase(currentLocate.getDisplayName())) {
                option.setSelected(true);
            }
            this.languages.add((SelectItemOption<String>)option);
        }
        Collections.sort(this.languages, new LanguagesComparator());
        UIFormInputSet uiSettingSet = new UIFormInputSet("PortalSetting");
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(IdentifierValidator.class, new Object[0]).setEditable(false)).addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_LOCALE, FIELD_LOCALE, this.languages).addValidator(MandatoryValidator.class, new Object[0]));
        ArrayList<SelectItemOption> listSkin = new ArrayList<SelectItemOption>();
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        Iterator<String> skinIterator = skinService.getAvailableSkins();
        while (skinIterator.hasNext()) {
            String skin = skinIterator.next();
            SelectItemOption skinOption = new SelectItemOption(skin, (Object)skin);
            if (uiPortal.getSkin().equals(skin)) {
                skinOption.setSelected(true);
            }
            listSkin.add(skinOption);
        }
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(FIELD_SKIN, FIELD_SKIN, listSkin);
        uiSettingSet.addUIFormInput((UIFormInput)uiSelectBox);
        this.addUIFormInput(uiSettingSet);
        UIFormInputSet uiPermissionSetting = (UIFormInputSet)this.createUIComponent(UIFormInputSet.class, "PermissionSetting", null);
        this.addUIComponentInput((UIComponent)uiPermissionSetting);
        UIListPermissionSelector uiListPermissionSelector = (UIListPermissionSelector)this.createUIComponent(UIListPermissionSelector.class, null, null);
        uiListPermissionSelector.configure("UIListPermissionSelector", "accessPermissions");
        uiListPermissionSelector.addValidator(UIListPermissionSelector.EmptyIteratorValidator.class, new Object[0]);
        uiPermissionSetting.addChild((UIComponent)uiListPermissionSelector);
        UIPermissionSelector uiEditPermission = (UIPermissionSelector)this.createUIComponent(UIPermissionSelector.class, null, null);
        uiEditPermission.setRendered(false);
        uiEditPermission.addValidator(UIPermissionSelector.MandatoryValidator.class, new Object[0]);
        uiEditPermission.configure("UIPermissionSelector", "editPermission");
        uiPermissionSetting.addChild((UIComponent)uiEditPermission);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectItemOptionActionListener
    extends EventListener<UIPortalForm> {
        public void execute(Event<UIPortalForm> event) throws Exception {
            UIPortalForm uiForm = (UIPortalForm)((Object)event.getSource());
            UIFormInputItemSelector templateInput = (UIFormInputItemSelector)uiForm.getChild(UIFormInputItemSelector.class);
            uiForm.setSelectedTab(templateInput.getId());
            PortalTemplateConfigOption selectItem = (PortalTemplateConfigOption)((Object)templateInput.getSelectedCategory().getSelectItemOptions().get(0));
            List<String> groupIds = selectItem.getGroups();
            Group[] groups = new Group[groupIds.size()];
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            for (int i = 0; i < groupIds.size(); ++i) {
                groups[i] = service.getGroupHandler().findGroupById(groupIds.get(i));
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateActionListener
    extends EventListener<UIPortalForm> {
        public void execute(Event<UIPortalForm> event) throws Exception {
            UIPortalForm uiForm = (UIPortalForm)((Object)event.getSource());
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            String template = ((UIFormInputItemSelector)uiForm.getChild(UIFormInputItemSelector.class)).getSelectedItemOption().getValue().toString();
            String portalName = (String)uiForm.getUIStringInput(UIPortalForm.FIELD_NAME).getValue();
            DataStorage dataService = (DataStorage)uiForm.getApplicationComponent(DataStorage.class);
            PortalConfig config = dataService.getPortalConfig(portalName);
            if (config != null) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPortalForm.msg.sameName", null));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UserPortalConfigService service = (UserPortalConfigService)uiForm.getApplicationComponent(UserPortalConfigService.class);
            service.createUserPortalConfig(portalName, template);
            UserPortalConfig userPortalConfig = service.getUserPortalConfig(portalName, pcontext.getRemoteUser());
            PortalConfig pconfig = userPortalConfig.getPortalConfig();
            uiForm.invokeSetBindingBean(pconfig);
            PageNavigation navigation = service.getPageNavigation("portal::" + portalName);
            navigation.setCreator(pcontext.getRemoteUser());
            pconfig.setCreator(pcontext.getRemoteUser());
            service.update(pconfig);
            service.update(navigation);
            UIPortalApplication uiPortalApp = (UIPortalApplication)((UIPortalForm)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWS.setUIComponent(null);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            UIPortalBrowser uiPortalBrowser = (UIPortalBrowser)uiPortalApp.findFirstComponentOfType(UIPortalBrowser.class);
            uiPortalBrowser.loadPortalConfigs();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalBrowser);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPortalForm> {
        public void execute(Event<UIPortalForm> event) throws Exception {
            UIPortalForm uiForm = (UIPortalForm)((Object)event.getSource());
            UIPortal uiPortal = Util.getUIPortal();
            uiForm.invokeSetBindingBean((Object)uiPortal);
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiForm.getParent();
            uiMaskWorkspace.setUIComponent(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LanguagesComparator
    implements Comparator<SelectItemOption> {
        private LanguagesComparator() {
        }

        @Override
        public int compare(SelectItemOption o1, SelectItemOption o2) {
            return o1.getLabel().compareToIgnoreCase(o2.getLabel());
        }
    }
}

