/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.skin;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.exoplatform.portal.webui.skin.SkinConfig;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinService {
    protected static Log log = ExoLogger.getLogger((String)"portal.SkinService");
    private static final String REGEXP = "@import url(.*).*;";
    private static final String BACKGROUND_REGEXP = "background.*:.*url(.*).*;";
    private static final String CSS_SERVLET_URL = "/portal/css";
    private Map<String, SkinConfig> skinConfigs_ = new HashMap<String, SkinConfig>(20);
    private HashSet<String> availableSkins_ = new HashSet(5);
    private Map<String, String> mergedCSS_;
    private Map<String, Set<String>> portletThemes_;
    private boolean cacheResource_ = !"true".equals(System.getProperty("exo.product.developing"));

    public SkinService() {
        this.mergedCSS_ = new HashMap<String, String>();
    }

    public Iterator<String> getAvailableSkins() {
        return this.availableSkins_.iterator();
    }

    public void addSkin(String module, String skinName, String cssPath, ServletContext scontext) {
        this.addSkin(module, skinName, cssPath, scontext, false);
    }

    public void addSkin(String module, String skinName, String cssPath, ServletContext scontext, boolean isPrimary) {
        this.availableSkins_.add(skinName);
        String key = module + "$" + skinName;
        SkinConfig skinConfig = this.skinConfigs_.get(key);
        if (skinConfig == null || !skinConfig.isPrimary()) {
            this.skinConfigs_.put(key, new SkinConfig(module, skinName, cssPath, isPrimary));
            this.mergeCSS(cssPath, scontext);
        }
    }

    public void invalidatePortalSkinCache(String portalName, String skinName) {
        String key = portalName + "$" + skinName;
        this.skinConfigs_.remove(key);
    }

    public SkinConfig getPortalSkin(String portalName, String skinName, List<String> portletInPortal) {
        String key = portalName + "$" + skinName;
        SkinConfig portalSkinConfig = this.skinConfigs_.get(key);
        if (portalSkinConfig == null) {
            StringBuffer buffer = new StringBuffer();
            for (String module : portletInPortal) {
                String portletCSS;
                String portletKey = module + "$" + skinName;
                SkinConfig portletConfig = this.skinConfigs_.get(portletKey);
                if (portletConfig == null || (portletCSS = this.mergedCSS_.get(portletConfig.getCSSPath())) == null) continue;
                buffer.append(portletCSS);
            }
            String cssPath = "/portal/css/" + key + ".css";
            this.mergedCSS_.put(cssPath, buffer.toString());
            portalSkinConfig = new SkinConfig(portalName, skinName, cssPath, false);
            this.skinConfigs_.put(key, portalSkinConfig);
        }
        return portalSkinConfig;
    }

    private void mergeCSS(String cssPath, ServletContext scontext) {
        if (this.cacheResource_) {
            String relativeCSSPath = cssPath.substring(cssPath.indexOf("/", 2));
            Pattern pattern = Pattern.compile(REGEXP);
            StringBuffer sB = new StringBuffer();
            String resolvedPath = relativeCSSPath.substring(0, relativeCSSPath.lastIndexOf("/") + 1);
            String includedPath = relativeCSSPath.substring(relativeCSSPath.lastIndexOf("/") + 1);
            this.processMergeRecursively(pattern, sB, scontext, resolvedPath, includedPath);
            this.mergedCSS_.put(cssPath, sB.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMergeRecursively(Pattern pattern, StringBuffer sB, ServletContext scontext, String basePath, String pathToResolve) {
        String resolvedPath = basePath.substring(0, basePath.lastIndexOf("/") + 1) + pathToResolve;
        String line = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(scontext.getResourceAsStream(resolvedPath)));
            try {
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (matcher.find()) {
                        String includedPath = "";
                        includedPath = line.contains("url('") || line.contains("url(\"") ? line.substring("@import url(".length() + 1, line.indexOf(")") - 1) : line.substring("@import url(".length(), line.indexOf(")"));
                        if (includedPath.startsWith("/")) {
                            String targetedContextName = includedPath.substring(includedPath.indexOf("/"), includedPath.indexOf("/", 2));
                            String targetedResolvedPath = includedPath.substring(includedPath.indexOf("/", 2), includedPath.lastIndexOf("/") + 1);
                            String targetedIncludedPath = includedPath.substring(includedPath.lastIndexOf("/") + 1);
                            ServletContext targetedContext = scontext.getContext(targetedContextName);
                            StringBuffer tempSB = new StringBuffer();
                            this.processMergeRecursively(pattern, tempSB, targetedContext, targetedResolvedPath, targetedIncludedPath);
                            sB.append(tempSB);
                            continue;
                        }
                        this.processMergeRecursively(pattern, sB, scontext, resolvedPath, includedPath);
                        continue;
                    }
                    String rootContext = resolvedPath.substring(0, resolvedPath.lastIndexOf("/") + 1);
                    String rootURL = "/" + scontext.getServletContextName() + rootContext;
                    this.rewriteLine(line, rootURL, sB);
                }
            }
            catch (Exception ex) {
                log.error((Object)("Problem while processing line : " + line), (Throwable)ex);
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            log.error((Object)("Problem while merging CSS : " + resolvedPath), (Throwable)e);
        }
    }

    private void rewriteLine(String line, String basePath, StringBuffer sB) {
        Pattern backgroundPattern = Pattern.compile(BACKGROUND_REGEXP);
        Matcher matcher = backgroundPattern.matcher(line);
        if (!matcher.find() || line.contains("url(/") || line.contains("url('/") || line.contains("url(\"/")) {
            sB.append(line + "\n");
            return;
        }
        int firstIndex = line.indexOf("url(") + "url(".length();
        int lastIndex = line.indexOf(")");
        sB.append(line.substring(0, firstIndex));
        String urlToRewrite = "";
        urlToRewrite = line.contains("url('") || line.contains("url(\"") ? line.substring(firstIndex + 1, lastIndex - 1) : line.substring(firstIndex, lastIndex);
        sB.append(basePath + urlToRewrite);
        sB.append(line.substring(lastIndex) + "\n");
    }

    public String getMergedCSS(String cssPath) {
        return this.mergedCSS_.get(cssPath);
    }

    public SkinConfig getSkin(String module, String skinName) {
        String key = module + "$" + skinName;
        if (skinName.length() == 0) {
            key = module + "$Default";
        }
        SkinConfig config = this.skinConfigs_.get(key);
        return config;
    }

    public int size() {
        return this.skinConfigs_.size();
    }

    public SkinConfig getSkin(String key) {
        return this.skinConfigs_.get(key);
    }

    public void remove(String key) throws Exception {
        this.skinConfigs_.remove(key);
    }

    public void remove(String module, String skinName) throws Exception {
        String key = module + "$" + skinName;
        if (skinName.length() == 0) {
            key = module + "$Default";
        }
        this.skinConfigs_.remove(key);
    }

    public void addTheme(String categoryName, List<String> themesName) {
        if (this.portletThemes_ == null) {
            this.portletThemes_ = new HashMap<String, Set<String>>();
        }
        if (!this.portletThemes_.containsKey(categoryName)) {
            this.portletThemes_.put(categoryName, new HashSet());
        }
        Set<String> catThemes = this.portletThemes_.get(categoryName);
        for (String theme : themesName) {
            catThemes.add(theme);
        }
    }

    public void addCategoryTheme(String categoryName) {
        if (this.portletThemes_ == null) {
            this.portletThemes_ = new HashMap<String, Set<String>>();
        }
        if (!this.portletThemes_.containsKey(categoryName)) {
            this.portletThemes_.put(categoryName, new HashSet());
        }
    }

    public Map<String, Set<String>> getPortletThemes() {
        return this.portletThemes_;
    }

    public void setPortletThemes(Map<String, Set<String>> portletThemes_) {
        this.portletThemes_ = portletThemes_;
    }
}

