/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.impl.core.XASessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.transaction.TransactionException;

public class TransactionableResourceManager {
    private Map<String, List<SoftReference<XASessionImpl>>> txManagers = new HashMap<String, List<SoftReference<XASessionImpl>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(XASessionImpl userSession) {
        List<SoftReference<XASessionImpl>> joinedList = this.txManagers.get(userSession.getUserID());
        if (joinedList != null) {
            List<SoftReference<XASessionImpl>> list = joinedList;
            synchronized (list) {
                ArrayList<SoftReference<XASessionImpl>> userSessions = new ArrayList<SoftReference<XASessionImpl>>(joinedList);
                ArrayList<SoftReference> removeList = new ArrayList<SoftReference>();
                for (SoftReference softReference : userSessions) {
                    XASessionImpl xaSession = (XASessionImpl)softReference.get();
                    if (xaSession != null && (xaSession == null || xaSession.isLive())) continue;
                    removeList.add(softReference);
                }
                for (SoftReference softReference : removeList) {
                    userSessions.remove(softReference);
                }
                userSessions.add(new SoftReference<XASessionImpl>(userSession));
                this.txManagers.put(userSession.getUserID(), userSessions);
            }
        } else {
            ArrayList<SoftReference<XASessionImpl>> newJoinedList = new ArrayList<SoftReference<XASessionImpl>>();
            newJoinedList.add(new SoftReference<XASessionImpl>(userSession));
            this.txManagers.put(userSession.getUserID(), newJoinedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(XASessionImpl userSession) throws TransactionException {
        List<SoftReference<XASessionImpl>> joinedList = null;
        Map<String, List<SoftReference<XASessionImpl>>> map = this.txManagers;
        synchronized (map) {
            joinedList = this.txManagers.remove(userSession.getUserID());
        }
        if (joinedList != null) {
            for (SoftReference<XASessionImpl> sr : joinedList) {
                XASessionImpl xaSession = sr.get();
                if (xaSession == null || !xaSession.isLive()) continue;
                TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                txManager.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(XASessionImpl userSession) {
        List<SoftReference<XASessionImpl>> joinedList = null;
        Map<String, List<SoftReference<XASessionImpl>>> map = this.txManagers;
        synchronized (map) {
            joinedList = this.txManagers.get(userSession.getUserID());
        }
        if (joinedList != null) {
            for (SoftReference<XASessionImpl> sr : joinedList) {
                XASessionImpl xaSession = sr.get();
                if (xaSession == null || !xaSession.isLive()) continue;
                TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                txManager.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(XASessionImpl userSession) {
        List<SoftReference<XASessionImpl>> joinedList = null;
        Map<String, List<SoftReference<XASessionImpl>>> map = this.txManagers;
        synchronized (map) {
            joinedList = this.txManagers.get(userSession.getUserID());
        }
        if (joinedList != null) {
            for (SoftReference<XASessionImpl> sr : joinedList) {
                XASessionImpl xaSession = sr.get();
                if (xaSession == null || !xaSession.isLive()) continue;
                TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                txManager.rollback();
            }
        }
    }
}

