/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.organization.auth.Identity;

public class ExoLoginJAASLoginModule
implements LoginModule {
    private Log log = ExoLogger.getLogger((String)"kernel.ExoLoginJAASLoginModule");
    private Subject subject_;
    private CallbackHandler callbackHandler_;
    private Identity identity_;
    private Map sharedState_;
    private PortalContainer cachedContainer_ = null;

    public ExoContainer getContainer() throws Exception {
        return RootContainer.getInstance().getPortalContainer("portal");
    }

    public void preProcessOperations() throws Exception {
        this.cachedContainer_ = PortalContainer.getInstance();
        PortalContainer container = this.cachedContainer_;
        if (container == null) {
            container = (PortalContainer)this.getContainer();
            PortalContainer.setInstance((PortalContainer)container);
        }
        List components = container.getComponentInstancesOfType(ComponentRequestLifecycle.class);
        for (ComponentRequestLifecycle component : components) {
            component.startRequest((ExoContainer)container);
        }
    }

    public void postProcessOperations() throws Exception {
        PortalContainer container = (PortalContainer)this.getContainer();
        List components = container.getComponentInstancesOfType(ComponentRequestLifecycle.class);
        if (components != null) {
            for (ComponentRequestLifecycle component : components) {
                component.endRequest((ExoContainer)container);
            }
        }
        PortalContainer.setInstance((PortalContainer)this.cachedContainer_);
    }

    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject_ = subject;
        this.callbackHandler_ = callbackHandler;
        this.sharedState_ = sharedState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean login() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In login of TomcatLoginModule");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
        ExoContainer container = null;
        try {
            try {
                this.callbackHandler_.handle(callbacks);
                String username = ((NameCallback)callbacks[0]).getName();
                String password = new String(((PasswordCallback)callbacks[1]).getPassword());
                ((PasswordCallback)callbacks[1]).clearPassword();
                if (username == null || password == null) {
                    boolean bl = false;
                    return bl;
                }
                this.sharedState_.put("javax.security.auth.login.name", username);
                this.subject_.getPrivateCredentials().add(password);
                container = this.getContainer();
                this.preProcessOperations();
                AuthenticationService authService = (AuthenticationService)container.getComponentInstanceOfType(AuthenticationService.class);
                if (!authService.login(username, password)) throw new LoginException("Authentication failed");
                boolean bl = true;
                return bl;
            }
            finally {
                this.postProcessOperations();
            }
        }
        catch (Throwable e) {
            throw new LoginException(e.toString()){
                private static final long serialVersionUID = 5843336633846631565L;

                public Throwable getCause() {
                    return e;
                }
            };
        }
    }

    public final boolean commit() throws LoginException {
        return true;
    }

    public final boolean abort() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In abort of TomcatLoginModule");
        }
        return true;
    }

    public final boolean logout() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In logout of TomcatLoginModule, It seems this method is never called in tomcat");
        }
        return true;
    }
}

