/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.security.Principal;
import java.util.Collection;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.auth.ExoLoginJAASLoginModule;
import org.exoplatform.services.organization.auth.JAASGroup;
import org.exoplatform.services.organization.auth.RolePrincipal;
import org.exoplatform.services.organization.auth.UserPrincipal;

public class JonasLoginModule
extends ExoLoginJAASLoginModule {
    protected void populateRolePrincipals(OrganizationService service, String username, Subject subject) throws Exception {
        subject.getPrincipals().add(new UserPrincipal(username));
        Collection groups = service.getGroupHandler().findGroupsOfUser(username);
        JAASGroup roleGroup = new JAASGroup("Roles");
        for (Group group : groups) {
            String groupId = group.getId();
            String[] splittedGroupName = StringUtils.split((String)groupId, (String)"/");
            roleGroup.addMember(new RolePrincipal(splittedGroupName[0]));
        }
        subject.getPrincipals().add((Principal)((Object)roleGroup));
    }
}

