/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.lifecycle;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.exoplatform.services.common.util.Stack;
import org.exoplatform.services.html.tidy.HTMLTidy;

public class HtmlValidator
extends Writer {
    private static boolean DEBUG_MODE = false;
    private Writer finalWriter_;
    private HTMLTidy tidy_;
    private StringBuilder content_;
    private Stack<Integer> queue;

    public HtmlValidator(Writer w) {
        this.finalWriter_ = w;
        if (!DEBUG_MODE) {
            return;
        }
        this.tidy_ = new HTMLTidy();
        this.content_ = new StringBuilder();
        this.queue = new Stack();
    }

    public void close() throws IOException {
        this.finalWriter_.close();
    }

    public void flush() throws IOException {
        this.finalWriter_.flush();
    }

    public void startComponent() {
        if (DEBUG_MODE) {
            this.queue.push((Object)this.content_.length());
        }
    }

    public void write(char[] buf, int offset, int len) throws IOException {
        this.finalWriter_.write(buf, offset, len);
        if (DEBUG_MODE) {
            this.content_.append(buf, offset, len);
        }
    }

    public void endComponent() throws Exception {
        if (!DEBUG_MODE) {
            return;
        }
        Integer start = (Integer)this.queue.pop();
        String chunk = this.content_.substring(start);
        this.content_.delete(start, this.content_.length() - 1);
        List messages = this.tidy_.check(chunk.toCharArray());
        if (messages.size() < 1) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (String ele : messages) {
            builder.append(ele).append('\n');
        }
        throw new Exception(builder.toString());
    }
}

