/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.exoplatform.services.common.DataBuffer;

public class HttpClientImpl {
    private HttpClient http;
    private DataBuffer buffer;
    public static int HTTP_TIMEOUT = 25000;
    public static int METHOD_TIMEOUT = 25000;

    public HttpClientImpl() throws Exception {
    }

    public HttpClientImpl(URL url) throws Exception {
        this.setURL(url);
    }

    public void setURL(URL url) throws Exception {
        System.setProperty("HTTPClient.cookies.save", "true");
        System.getProperties().put("HTTPClient.dontChunkRequests", "true");
        this.setHost(url.getProtocol(), url.getHost(), url.getPort());
    }

    private void setHost(String protocol, String host, int port) throws Exception {
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams para = new HttpConnectionManagerParams();
        para.setConnectionTimeout(HTTP_TIMEOUT);
        para.setDefaultMaxConnectionsPerHost(10);
        para.setMaxTotalConnections(20);
        para.setStaleCheckingEnabled(true);
        manager.setParams(para);
        this.http = new HttpClient((HttpConnectionManager)manager);
        this.http.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        this.http.getParams().setParameter("http.socket.timeout", (Object)new Integer(HTTP_TIMEOUT));
        this.http.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        this.http.getParams().setCookiePolicy("rfc2109");
        this.http.getParams().setCookiePolicy("compatibility");
        if (port < 0) {
            port = 80;
        }
        HostConfiguration hostConfig = this.http.getHostConfiguration();
        hostConfig.setHost(host, port, protocol);
        String proxyHost = System.getProperty("httpclient.proxy.host");
        if (proxyHost == null || proxyHost.trim().length() < 1) {
            return;
        }
        String proxyPort = System.getProperty("httpclient.proxy.port");
        hostConfig.setProxy(proxyHost, Integer.parseInt(proxyPort));
        String username = System.getProperty("httpclient.proxy.username");
        String password = System.getProperty("httpclient.proxy.password");
        NTCredentials ntCredentials = new NTCredentials("userid", "password", username, password);
        this.http.getState().setProxyCredentials(AuthScope.ANY, (Credentials)ntCredentials);
    }

    public HttpClient getHttpClient() {
        return this.http;
    }

    public byte[] loadContent(String link) throws Exception {
        GetMethod get = this.getMethod(link);
        if (get == null) {
            return new byte[0];
        }
        get.setFollowRedirects(true);
        get.getParams().setParameter("http.socket.timeout", (Object)new Integer(METHOD_TIMEOUT));
        int status = this.http.executeMethod((HttpMethod)get);
        if (status != 200) {
            return new byte[0];
        }
        InputStream in = get.getResponseBodyAsStream();
        BufferedInputStream input = new BufferedInputStream(in);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int read = 0;
        while ((read = input.read(b)) > -1) {
            output.write(b, 0, read);
        }
        in.close();
        input.close();
        get.releaseConnection();
        b = output.toByteArray();
        output.flush();
        output.close();
        return b;
    }

    public InputStream loadContentByInput(String link) throws Exception {
        GetMethod get = this.getMethod(link);
        if (get == null) {
            return null;
        }
        int status = this.http.executeMethod((HttpMethod)get);
        if (status == 200) {
            return get.getResponseBodyAsStream();
        }
        return null;
    }

    public String loadResource(String link, File file) throws Exception {
        GetMethod get = this.getMethod(link);
        if (get == null) {
            return link;
        }
        int status = this.http.executeMethod((HttpMethod)get);
        if (status != 200) {
            return link;
        }
        if (this.buffer == null) {
            this.buffer = new DataBuffer();
        }
        this.buffer.save(file, get.getResponseBody());
        get.releaseConnection();
        return link;
    }

    public GetMethod getMethod(String link) throws Exception {
        URL url;
        if (link.toLowerCase().startsWith("ftp://")) {
            return null;
        }
        if ((link.startsWith("http://") || link.startsWith("shttp://")) && !(url = new URL(link)).getHost().toLowerCase().equals(this.http.getHostConfiguration().getHost().toLowerCase())) {
            return null;
        }
        if (link.startsWith("www.") && !link.toLowerCase().equals(this.http.getHostConfiguration().getHost().toLowerCase())) {
            return null;
        }
        GetMethod get = new GetMethod(link);
        get.setFollowRedirects(true);
        get.getParams().setParameter("http.socket.timeout", (Object)new Integer(METHOD_TIMEOUT));
        return get;
    }
}

