/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.SQLException;
import org.enhydra.jdbc.standard.StandardPreparedStatement;
import org.enhydra.jdbc.standard.StandardXAConnectionHandle;

public class StandardXAPreparedStatement
extends StandardPreparedStatement {
    private StandardXAConnectionHandle con;
    public String sql;
    public int resultSetType;
    public int resultSetConcurrency;
    public int resultSetHoldability;
    public int autoGeneratedKeys;

    StandardXAPreparedStatement(StandardXAConnectionHandle con_, String sql_, int resultSetType_, int resultSetConcurrency_, int resultSetHoldability_) throws SQLException {
        this.con = con_;
        this.sql = sql_;
        this.key = sql_ + resultSetType_ + resultSetConcurrency_ + resultSetHoldability_;
        this.resultSetType = resultSetType_;
        this.resultSetConcurrency = resultSetConcurrency_;
        this.resultSetHoldability = resultSetHoldability_;
        this.log = con_.log;
        this.log.debug("StandardXAPreparedStatement: Create an XAPreparedStatement with sql='" + this.sql + "'");
        this.key = this.sql + this.resultSetType + this.resultSetConcurrency + this.resultSetHoldability + (this.con.tx != null);
        this.ps = this.con.checkPreparedCache(this.sql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, this.key);
    }

    StandardXAPreparedStatement(StandardXAConnectionHandle con_, String sql_, int autoGeneratedKeys_) throws SQLException {
        this.con = con_;
        this.sql = sql_;
        this.key = sql_ + autoGeneratedKeys_;
        this.autoGeneratedKeys = autoGeneratedKeys_;
        this.log = con_.log;
        this.log.debug("StandardXAPreparedStatement: Create an XAPreparedStatement with sql='" + this.sql + "'");
        this.key = this.sql + this.autoGeneratedKeys + (this.con.tx != null);
        this.ps = this.con.checkPreparedCache(this.sql, this.autoGeneratedKeys, this.key);
    }

    public synchronized void close() throws SQLException {
        this.log.debug("StandardXAPreparedStatement:close the XA prepared statement");
        this.closed = true;
        if (this.con.preparedStmtCacheSize == 0) {
            this.log.debug("StandardXAPreparedStatement:close preparedStmtCacheSize == 0");
            if (this.ps != null) {
                this.ps.close();
            }
        } else {
            this.log.debug("StandardXAPreparedStatement:close preparedStmtCacheSize='" + this.con.preparedStmtCacheSize + "'");
            this.con.returnToCache(this.key);
        }
    }

    public void catchInvoke(SQLException sqlException) throws SQLException {
        throw sqlException;
    }
}

