/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.commons.utils.ObjectPageList;

public abstract class PageList {
    public static final PageList EMPTY_LIST = new ObjectPageList(new ArrayList(), 10);
    private int pageSize_;
    protected int available_ = 0;
    protected int availablePage_ = 1;
    protected int currentPage_ = -1;
    protected List currentListPage_;

    public PageList(int pageSize) {
        this.pageSize_ = pageSize;
    }

    public int getPageSize() {
        return this.pageSize_;
    }

    public void setPageSize(int pageSize) {
        this.pageSize_ = pageSize;
        this.setAvailablePage(this.available_);
    }

    public int getCurrentPage() {
        return this.currentPage_;
    }

    public int getAvailable() {
        return this.available_;
    }

    public int getAvailablePage() {
        return this.availablePage_;
    }

    public List currentPage() throws Exception {
        if (this.currentListPage_ == null) {
            this.populateCurrentPage(this.currentPage_);
        }
        return this.currentListPage_;
    }

    protected abstract void populateCurrentPage(int var1) throws Exception;

    public List getPage(int page) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPage(page);
        return this.currentListPage_;
    }

    public abstract List getAll() throws Exception;

    protected void checkAndSetPage(int page) throws Exception {
        if (page < 1 || page > this.availablePage_) {
            Object[] args = new Object[]{Integer.toString(page), Integer.toString(this.availablePage_)};
            throw new ExoMessageException("PageList.page-out-of-range", args);
        }
        this.currentPage_ = page;
    }

    protected void setAvailablePage(int available) {
        this.available_ = available;
        if (available == 0) {
            this.availablePage_ = 1;
            this.currentPage_ = 1;
        } else {
            int pages = available / this.pageSize_;
            if (available % this.pageSize_ > 0) {
                ++pages;
            }
            this.availablePage_ = pages;
            this.currentPage_ = 1;
        }
    }

    public int getFrom() {
        return (this.currentPage_ - 1) * this.pageSize_;
    }

    public int getTo() {
        int to = this.currentPage_ * this.pageSize_;
        if (to > this.available_) {
            to = this.available_;
        }
        return to;
    }
}

