/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.log.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.ExceptionUtil;
import org.exoplatform.services.log.LogMessage;
import org.exoplatform.services.log.impl.ExoLog;

public class BufferedLog {
    public static final int LOG_BUFFER_SIZE = ExoLog.LOG_BUFFER_SIZE;
    public static final int ERROR_BUFFER_SIZE = ExoLog.ERROR_BUFFER_SIZE;
    static List logBuffer_ = ExoLog.getLogBuffer();
    static List errorBuffer_ = ExoLog.getErrorBuffer();
    static final String EXO_PREFIX = " - ";
    protected String prefix_;
    private Log logger;

    public BufferedLog(Log logger, String name) {
        this.logger = logger;
        int index = name.lastIndexOf(".");
        String nameSuffix = name;
        if (index > 0) {
            nameSuffix = name.substring(index + 1, name.length());
        }
        this.prefix_ = " - [" + nameSuffix + "] ";
    }

    public void trace(Object message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.TRACE, message.toString(), strace));
        }
    }

    public void trace(Object message) {
        if (this.logger.isDebugEnabled()) {
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.TRACE, message.toString(), null));
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.DEBUG, message.toString(), strace));
        }
    }

    public void debug(Object message) {
        if (this.logger.isDebugEnabled()) {
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.DEBUG, message.toString(), null));
        }
    }

    public void error(Object message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.ERROR, message.toString(), strace));
        }
    }

    public void error(Object message) {
        if (this.logger.isErrorEnabled()) {
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.ERROR, message.toString(), null));
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.logger.isFatalEnabled()) {
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.FATAL, message.toString(), strace));
        }
    }

    public void fatal(Object message) {
        if (this.logger.isFatalEnabled()) {
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.FATAL, message.toString(), null));
        }
    }

    public void info(Object message, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.INFO, message.toString(), strace));
        }
    }

    public void info(Object message) {
        if (this.logger.isInfoEnabled()) {
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.INFO, message.toString(), null));
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            String strace = ExceptionUtil.getExoStackTrace((Throwable)t);
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.WARN, message.toString(), strace));
        }
    }

    public void warn(Object message) {
        if (this.logger.isWarnEnabled()) {
            BufferedLog.addLogMessage(new LogMessage(this.prefix_, LogMessage.WARN, message.toString(), null));
        }
    }

    protected Log logger() {
        return this.logger;
    }

    private static void addLogMessage(LogMessage lm) {
        int i;
        ArrayList list;
        logBuffer_.add(lm);
        if (logBuffer_.size() == LOG_BUFFER_SIZE * 2) {
            list = new ArrayList(LOG_BUFFER_SIZE * 2);
            for (i = LOG_BUFFER_SIZE; i < logBuffer_.size(); ++i) {
                list.add(logBuffer_.get(i));
            }
            logBuffer_ = list;
        }
        if (lm.getType() == LogMessage.ERROR || lm.getType() == LogMessage.FATAL) {
            errorBuffer_.add(lm);
            if (errorBuffer_.size() == ERROR_BUFFER_SIZE * 2) {
                list = new ArrayList(ERROR_BUFFER_SIZE * 2);
                for (i = ERROR_BUFFER_SIZE; i < errorBuffer_.size(); ++i) {
                    list.add(errorBuffer_.get(i));
                }
                errorBuffer_ = list;
            }
        }
    }
}

