/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jgroups.blocks.DistributedTree;
import org.jgroups.demos.MyNode;

public class DistributedTreeDemo
extends Frame
implements WindowListener,
DistributedTree.DistributedTreeListener,
TreeSelectionListener,
TableModelListener {
    DefaultTreeModel tree_model = null;
    JTree jtree = null;
    final DefaultTableModel table_model = new DefaultTableModel();
    final JTable table = new JTable(this.table_model);
    JScrollPane scroll_pane = null;
    final MyNode root = new MyNode("/");
    DistributedTree dt = null;
    String props = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=0):PING(timeout=5000;num_initial_members=6):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=5;retransmit_timeout=3000):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=10000):FRAG(down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    String selected_node = null;
    boolean create = false;

    public DistributedTreeDemo(boolean create) throws Exception {
        this.create = create;
        this.dt = new DistributedTree("DistributedTreeDemo", this.props);
        this.dt.addDistributedTreeListener(this);
        this.setLayout(new BorderLayout());
        this.addNotify();
        this.setSize(this.getInsets().left + this.getInsets().right + 485, this.getInsets().top + this.getInsets().bottom + 367);
        this.setTitle("DistributedTree");
        this.tree_model = new DefaultTreeModel(this.root);
        this.jtree = new JTree(this.tree_model);
        this.jtree.setDoubleBuffered(true);
        this.scroll_pane = new JScrollPane();
        this.scroll_pane.getViewport().add(this.jtree);
        this.scroll_pane.setDoubleBuffered(true);
        this.add((Component)this.scroll_pane, "Center");
        this.addWindowListener(this);
        this.table_model.setColumnIdentifiers(new String[]{"Name", "Value"});
        this.table_model.addTableModelListener(this);
        this.add((Component)this.table, "South");
        this.dt.start();
        System.out.println("Constructing initial GUI tree");
        this.populateTree(this.dt, "");
        System.out.println("Constructing initial GUI tree -- done");
        Properties props1 = new Properties();
        props1.setProperty("name", "EventService");
        props1.setProperty("path", "/usr/local/Orbix2000/bin/es");
        props1.setProperty("up", "true");
        props1.setProperty("active", "false");
        Properties props2 = new Properties();
        props2.setProperty("name", "NamingService");
        props2.setProperty("path", "/usr/local/Orbix2000/bin/ns");
        props2.setProperty("up", "true");
        props2.setProperty("active", "true");
        Properties props3 = new Properties();
        props3.setProperty("name", "ORBIX daemon");
        props3.setProperty("path", "/usr/local/Orbix2000/bin/orbixd");
        props3.setProperty("up", "true");
        props3.setProperty("active", "true");
        props3.setProperty("restart", "true");
        props3.setProperty("restart_time", "3000");
        props3.setProperty("restart_max", "10");
        Properties props4 = new Properties();
        props4.setProperty("name", "Orbix2000 Version 1.1");
        props4.setProperty("valid until", "11/12/2001");
        props4.setProperty("up", "false");
        props4.setProperty("active", "false");
        Properties props5 = new Properties();
        props5.setProperty("name", "Orbix2000 Version 1.3b");
        props5.setProperty("valid until", "12/31/2000");
        props5.setProperty("up", "true");
        props5.setProperty("active", "false");
        if (create) {
            this.dt.add("/procs/NETSMART/es", props1);
            this.dt.add("/procs/NETSMART/ns", props2);
            this.dt.add("/procs/NETSMART/orbixd", props3);
            this.dt.add("/procs/NETSMART/orbixd/Version_1.1", props4);
            this.dt.add("/procs/NETSMART/orbixd/Version_1.2", props5);
            Properties props6 = (Properties)props5.clone();
            props6.setProperty("name", "osagent daemon");
            props6.setProperty("path", "/usr/local/Visigenics/bin/osagent");
            Properties props7 = new Properties();
            props7.setProperty("name", "Visigenics latest product");
            props7.setProperty("license", "/vob/iem/Devp/etc/license.txt");
            this.dt.set("/procs/NETSMART/orbixd/Version_1.2", props6);
            this.dt.add("/procs/NETSMART/orbixd/Version_2.0", props7);
        }
        this.jtree.addTreeSelectionListener(this);
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int selRow = DistributedTreeDemo.this.jtree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = DistributedTreeDemo.this.jtree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    DistributedTreeDemo.this.selected_node = DistributedTreeDemo.this.makeFQN(selPath.getPath());
                }
            }
        };
        this.jtree.addMouseListener(ml);
    }

    String makeFQN(Object[] path) {
        String tmp_name;
        StringBuffer sb = new StringBuffer("");
        if (path == null) {
            return null;
        }
        for (int i = 0; i < path.length; ++i) {
            tmp_name = ((MyNode)path[i]).name;
            if ("/".equals(tmp_name)) continue;
            sb.append('/' + tmp_name);
        }
        tmp_name = sb.toString();
        if (tmp_name.length() == 0) {
            return "/";
        }
        return tmp_name;
    }

    void clearTable() {
        int num_rows = this.table.getRowCount();
        if (num_rows > 0) {
            for (int i = 0; i < num_rows; ++i) {
                this.table_model.removeRow(0);
            }
            this.table_model.fireTableRowsDeleted(0, num_rows - 1);
            this.repaint();
        }
    }

    void populateTable(Properties props) {
        int num_rows = 0;
        if (props == null) {
            return;
        }
        num_rows = props.size();
        this.clearTable();
        if (num_rows > 0) {
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = (String)props.get(key);
                if (val == null) {
                    val = "<n/a>";
                }
                this.table_model.addRow(new Object[]{key, val});
            }
            this.table_model.fireTableRowsInserted(0, num_rows - 1);
            this.validate();
        }
    }

    void populateTree(DistributedTree tree, String tmp_fqn) {
        if (tree == null) {
            return;
        }
        Vector children = tree.getChildrenNames(tmp_fqn);
        for (int i = 0; i < children.size(); ++i) {
            String child_name = (String)children.elementAt(i);
            String tmp_name = tmp_fqn + '/' + child_name;
            this.root.add(tmp_name, tree.get(tmp_name));
            this.populateTree(tree, tmp_name);
        }
    }

    public synchronized void setVisible(boolean show) {
        this.setLocation(50, 50);
        super.setVisible(show);
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.dt.stop();
        System.exit(0);
    }

    public void tableChanged(TableModelEvent evt) {
        if (evt.getType() == 0) {
            String val;
            String key;
            int row = evt.getFirstRow();
            int col = evt.getColumn();
            Properties props = (Properties)this.dt.get(this.selected_node);
            if (col == 0) {
                key = (String)this.table_model.getValueAt(row, col);
                val = (String)this.table_model.getValueAt(row, col + 1);
                if (props != null && key != null && val != null) {
                    props.setProperty(key, val);
                    this.dt.set(this.selected_node, props);
                }
            } else {
                key = (String)this.table_model.getValueAt(row, col - 1);
                val = (String)this.table.getValueAt(row, col);
                if (props != null && key != null && val != null) {
                    props.setProperty(key, val);
                    this.dt.add(this.selected_node, props);
                }
            }
            System.out.println("key=" + key + ", val=" + val);
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        String fqn = "/";
        Properties props = null;
        for (int i = 0; i < path.getPathCount(); ++i) {
            String component_name = ((MyNode)path.getPathComponent((int)i)).name;
            if ("/".equals(component_name)) continue;
            fqn = "/".equals(fqn) ? fqn + component_name : fqn + '/' + component_name;
        }
        props = (Properties)this.dt.get(fqn);
        if (props != null) {
            this.populateTable(props);
        } else {
            this.clearTable();
        }
    }

    public void nodeAdded(String fqn, Serializable element) {
        System.out.println("** nodeCreated(" + fqn + ')');
        this.root.add(fqn, element);
        MyNode n = this.root.findNode(fqn);
        if (n != null) {
            this.tree_model.reload(n.getParent());
        }
    }

    public void nodeRemoved(String fqn) {
        System.out.println("** nodeRemoved(" + fqn + ')');
        MyNode n = this.root.findNode(fqn);
        if (n != null) {
            n.removeAllChildren();
            TreeNode par = n.getParent();
            n.removeFromParent();
            this.tree_model.reload(par);
        }
    }

    public void nodeModified(String fqn, Serializable old_element, Serializable new_element) {
        System.out.println("** nodeModified(" + fqn + ')');
        this.root.modify(fqn, new_element);
        this.populateTable((Properties)new_element);
    }

    public static void main(String[] args) {
        boolean create = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                System.out.println("DistributedTreeDemo [-create] [-help]");
                return;
            }
            if (!"-create".equals(args[i])) continue;
            create = true;
        }
        try {
            DistributedTreeDemo demo = new DistributedTreeDemo(create);
            demo.setVisible(true);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

