/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Event;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.PingSender;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class PingWaiter
implements Runnable {
    private Thread thread = null;
    private final Lock thread_lock = new ReentrantLock();
    final List rsps = new LinkedList();
    private long timeout = 3000L;
    private int num_rsps = 3;
    Protocol parent = null;
    private PingSender ping_sender;
    protected final Log log = LogFactory.getLog(this.getClass());

    public PingWaiter(long timeout, int num_rsps, Protocol parent, PingSender ping_sender) {
        this.timeout = timeout;
        this.num_rsps = num_rsps;
        this.parent = parent;
        this.ping_sender = ping_sender;
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    void setNumRsps(int num) {
        this.num_rsps = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.thread_lock.lock();
        try {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread(Util.getGlobalThreadGroup(), this, "PingWaiter");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
        finally {
            this.thread_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.ping_sender.stop();
        boolean stopped = false;
        this.thread_lock.lock();
        try {
            if (this.thread != null) {
                this.thread = null;
                stopped = true;
            }
        }
        finally {
            this.thread_lock.unlock();
        }
        if (stopped) {
            List list = this.rsps;
            synchronized (list) {
                this.rsps.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponse(PingRsp rsp) {
        if (rsp != null) {
            List list = this.rsps;
            synchronized (list) {
                if (this.rsps.contains(rsp)) {
                    this.rsps.remove(rsp);
                }
                this.rsps.add(rsp);
                this.rsps.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResponses() {
        List list = this.rsps;
        synchronized (list) {
            this.rsps.clear();
            this.rsps.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Vector responses = this.findInitialMembers();
        this.thread_lock.lock();
        try {
            this.thread = null;
        }
        finally {
            this.thread_lock.unlock();
        }
        if (this.parent != null) {
            this.parent.getUpProtocol().up(new Event(13, responses));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector findInitialMembers() {
        List list = this.rsps;
        synchronized (list) {
            Vector vector;
            this.rsps.clear();
            this.ping_sender.start();
            long start_time = System.currentTimeMillis();
            long time_to_wait = this.timeout;
            try {
                while (true) {
                    boolean cond;
                    boolean bl = cond = this.rsps.size() < this.num_rsps && time_to_wait > 0L && this.thread != null && Thread.currentThread().equals(this.thread);
                    if (!cond) break;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)new StringBuilder("waiting for initial members: time_to_wait=").append(time_to_wait).append(", got ").append(this.rsps.size()).append(" rsps"));
                    }
                    try {
                        this.rsps.wait(time_to_wait);
                    }
                    catch (InterruptedException intex) {
                    }
                    catch (Exception e) {
                        this.log.error((Object)"got an exception waiting for responses", (Throwable)e);
                    }
                    time_to_wait = this.timeout - (System.currentTimeMillis() - start_time);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)new StringBuffer("initial mbrs are ").append(this.rsps));
                }
                vector = new Vector(this.rsps);
                this.ping_sender.stop();
            }
            catch (Throwable throwable) {
                this.ping_sender.stop();
                throw throwable;
            }
            return vector;
        }
    }
}

