/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.json;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.json.ArrayToJSONPlugin;
import org.exoplatform.json.BeanToJSONPlugin;
import org.exoplatform.json.JSONMap;
import org.exoplatform.json.MapToJSONPlugin;
import org.exoplatform.json.ReflectToJSONPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONService {
    public static int NUMBER_SPACE = 3;
    private HashMap<Class, BeanToJSONPlugin> plugins_ = new HashMap();

    public JSONService() throws Exception {
        this.register(ReflectToJSONPlugin.class, new ReflectToJSONPlugin());
        this.register(ArrayToJSONPlugin.class, new ArrayToJSONPlugin());
        this.register(MapToJSONPlugin.class, new MapToJSONPlugin());
    }

    public void register(Class clazz, BeanToJSONPlugin plugin) {
        plugin.setService(this);
        this.plugins_.put(clazz, plugin);
    }

    public void unregister(Class clazz) {
        if (!this.plugins_.containsKey(clazz)) {
            return;
        }
        this.plugins_.remove(clazz);
    }

    public <T> void toJSONScript(T bean, StringBuilder b, int indentLevel) throws Exception {
        BeanToJSONPlugin plugin = this.getConverterPlugin(bean);
        plugin.toJSONScript(bean, b, indentLevel);
        int s = b.lastIndexOf(",");
        int k = b.lastIndexOf(":");
        if (s > k) {
            b.deleteCharAt(s);
        }
    }

    public ArrayToJSONPlugin getArrayToJSONPlugin() {
        return (ArrayToJSONPlugin)this.plugins_.get(ArrayToJSONPlugin.class);
    }

    public BeanToJSONPlugin getConverterPlugin(Object object) throws Exception {
        Class<?> clazz = object.getClass();
        BeanToJSONPlugin plugin = null;
        if (this.plugins_.containsKey(clazz)) {
            plugin = this.plugins_.get(clazz);
        }
        if (plugin != null) {
            return plugin;
        }
        if (object instanceof Map || object instanceof JSONMap) {
            plugin = this.plugins_.get(MapToJSONPlugin.class);
        }
        if (plugin != null) {
            return plugin;
        }
        if (clazz.isArray()) {
            plugin = this.plugins_.get(ArrayToJSONPlugin.class);
        }
        if (plugin != null) {
            return plugin;
        }
        return this.plugins_.get(ReflectToJSONPlugin.class);
    }

    public BeanToJSONPlugin getConverterPlugin(Class clazz) throws Exception {
        if (clazz.isArray()) {
            return this.plugins_.get(ArrayToJSONPlugin.class);
        }
        if (this.plugins_.containsKey(clazz)) {
            return this.plugins_.get(clazz);
        }
        return this.plugins_.get(ReflectToJSONPlugin.class);
    }
}

