/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.command;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.activation.UnknownObjectException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.command.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHandler
extends WebRequestHandler {
    @Override
    public String[] getPath() {
        return new String[]{"/command"};
    }

    @Override
    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        Map props = req.getParameterMap();
        String type = req.getParameter("type");
        if (type == null || type.trim().length() < 1) {
            throw new NullPointerException("Unknown type command handler");
        }
        Command command = this.createCommand(type, props);
        if (command == null) {
            throw new UnknownObjectException("Unknown command handler with type is " + type);
        }
        command.execute(controller, req, res);
    }

    public Command createCommand(String type, Map props) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = classLoader.loadClass(type);
        Object object = clazz.newInstance();
        for (Object key : props.keySet()) {
            Field field = this.getField(clazz, key.toString());
            if (field == null) continue;
            this.setValue(object, field, props.get(key));
        }
        return (Command)object;
    }

    private final void setValue(Object bean, Field field, Object value) throws Exception {
        Class<?> type = field.getType();
        if (type.isArray() && !value.getClass().isArray()) {
            value = this.toValues(type, new Object[]{value});
        } else if (type.isArray() && value.getClass().isArray()) {
            value = this.toValues(type, value);
        } else {
            if (!type.isArray() && value.getClass().isArray()) {
                value = Array.get(value, 0);
            }
            value = this.toValue(type, value);
        }
        Class<?> clazz = bean.getClass();
        Method method = this.getMethod("set", field, clazz);
        if (method != null) {
            method.invoke(bean, value);
            return;
        }
        field.setAccessible(true);
        field.set(bean, value);
    }

    private final Method getMethod(String prefix, Field field, Class clazz) throws Exception {
        StringBuilder name = new StringBuilder(field.getName());
        name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        name.insert(0, prefix);
        return this.getMethodByName(name.toString(), field, clazz);
    }

    private final Method getMethodByName(String name, Field field, Class clazz) {
        try {
            Method method = clazz.getDeclaredMethod(name.toString(), field.getType());
            if (method != null) {
                return method;
            }
            if (clazz == Object.class) {
                return null;
            }
            method = this.getMethodByName(name, field, clazz.getSuperclass());
            if (method != null) {
                return method;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private Field getField(Class clazz, String name) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (field != null) {
            return field;
        }
        if (clazz == Object.class) {
            return null;
        }
        return this.getField(clazz.getSuperclass(), name);
    }

    private Object toValues(Class<?> clazz, Object objects) {
        Class<?> componentType = clazz.getComponentType();
        Object newValues = Array.newInstance(componentType, Array.getLength(objects));
        for (int i = 0; i < Array.getLength(objects); ++i) {
            Array.set(newValues, i, this.toValue(componentType, Array.get(objects, i)));
        }
        return clazz.cast(newValues);
    }

    private Object toValue(Class<?> clazz, Object object) {
        if (clazz == Integer.TYPE) {
            return (int)new Integer(object.toString());
        }
        if (clazz == Short.TYPE) {
            return (short)new Short(object.toString());
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(new Float(object.toString()).floatValue());
        }
        if (clazz == Double.TYPE) {
            return (double)new Double(object.toString());
        }
        if (clazz == Boolean.TYPE) {
            return (boolean)new Boolean(object.toString());
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf(object.toString().trim().charAt(0));
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(object.toString());
        }
        catch (Exception exception) {
            return object.toString();
        }
    }
}

