/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.webui.novaview;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.ow2.orchestra.console.webui.novaview.UINovaViewContainer;
import org.ow2.orchestra.console.webui.novaview.UINovaViewManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UINovaViewTabulation
extends UINovaViewContainer {
    private int visibleSize = 4;
    private List<UIComponent> hiddenChildren;

    public boolean hasHiddenChildren() {
        return this.hiddenChildren != null;
    }

    public List<UIComponent> getHiddenChildren() {
        if (this.hiddenChildren == null) {
            this.hiddenChildren = new ArrayList<UIComponent>(3);
        }
        return this.hiddenChildren;
    }

    public void addChild(UIComponent component) {
        if (this.getChildren().size() < this.visibleSize) {
            super.addChild(component);
        } else {
            this.addHiddenChild(component);
        }
    }

    public <T extends UIComponent> T getChildById(String id) {
        UIComponent child = super.getChildById(id);
        if (child == null) {
            for (UIComponent ui : this.hiddenChildren) {
                if (!ui.getId().equals(id)) continue;
                return (T)ui;
            }
        }
        return (T)child;
    }

    public <T extends UIComponent> T removeChildById(String id) {
        UIComponent c = super.removeChildById(id);
        if (c != null) {
            if (this.hiddenChildren != null && this.hiddenChildren.size() > 0) {
                super.addChild(this.hiddenChildren.remove(0));
            }
            return (T)c;
        }
        if (this.hiddenChildren == null) {
            return null;
        }
        for (UIComponent child : this.hiddenChildren) {
            if (!id.equals(child.getId())) continue;
            child.setParent(null);
            this.hiddenChildren.remove(child);
            return (T)child;
        }
        return null;
    }

    public <T extends UIComponent> T removeChild(Class<T> clazz) {
        UIComponent c = super.removeChild(clazz);
        if (c != null) {
            return (T)c;
        }
        if (this.hiddenChildren == null) {
            return null;
        }
        for (UIComponent child : this.hiddenChildren) {
            if (!clazz.isInstance(child)) continue;
            child.setParent(null);
            this.hiddenChildren.remove(child);
            return (T)((UIComponent)clazz.cast(child));
        }
        return null;
    }

    @Override
    public void switchView(String viewId) {
        if (this.isSwitchView()) {
            this.switchVisibleView(viewId);
            this.switchHiddenView(viewId);
        }
    }

    private void switchVisibleView(String viewId) {
        List list = this.getChildren();
        for (UIComponent component : list) {
            if (component.getId().equals(viewId)) {
                component.setRendered(true);
                continue;
            }
            component.setRendered(false);
        }
    }

    private void switchHiddenView(String viewId) {
        List<UIComponent> list = this.getHiddenChildren();
        ArrayList<UIComponent> toSwitch = new ArrayList<UIComponent>();
        for (UIComponent component : list) {
            if (component.getId().equals(viewId)) {
                component.setRendered(true);
                toSwitch.add(component);
                continue;
            }
            component.setRendered(false);
        }
        for (UIComponent component : toSwitch) {
            this.hiddenChildren.remove(component);
            this.hiddenChildren.add(0, component);
            if (this.getChildren().size() > 0) {
                this.addHiddenChild((UIComponent)this.removeChildById(this.getChild(0).getId()));
            }
            if (this.getChildren().size() >= this.visibleSize) continue;
            this.hiddenChildren.remove(component);
            super.addChild(component);
        }
    }

    private void addHiddenChild(UIComponent uicomponent) {
        if (this.hiddenChildren == null) {
            this.hiddenChildren = new ArrayList<UIComponent>(3);
        }
        uicomponent.setParent((UIComponent)this);
        this.hiddenChildren.add(uicomponent);
    }

    public void setVisibleSize(int size) {
        this.visibleSize = size;
    }

    public int getVisibleSize() {
        return this.visibleSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseAllViewActionListener
    extends EventListener<UINovaViewTabulation> {
        public void execute(Event<UINovaViewTabulation> event) throws Exception {
            UINovaViewTabulation uiContainer = (UINovaViewTabulation)((Object)event.getSource());
            UINovaViewManagement viewMgt = (UINovaViewManagement)uiContainer.getAncestorOfType(UINovaViewManagement.class);
            ArrayList<String> ids = new ArrayList<String>();
            for (UIComponent child : uiContainer.getChildren()) {
                ids.add(child.getId());
            }
            for (UIComponent child : uiContainer.getHiddenChildren()) {
                ids.add(child.getId());
            }
            for (String id : ids) {
                viewMgt.closeView(id);
            }
            viewMgt.addContainerToUpdateByAjax(event.getRequestContext());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)viewMgt.getViewer());
        }
    }
}

