/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.security;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.ow2.orchestra.console.security.ProfileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NovaACL {
    private Map<String, Collection<String>> accessList = new HashMap<String, Collection<String>>();
    private ProfileManager profileManager;

    public NovaACL(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    public boolean hasPermission(String userName, String key) {
        boolean hasPermission = false;
        Collection<String> profiles = this.profileManager.getProfiles(userName);
        for (String profile : profiles) {
            if (!this.accessList.containsKey(profile)) continue;
            hasPermission = hasPermission || this.accessList.get(profile).contains(key);
        }
        return hasPermission;
    }

    public void givePermission(String profile, String key) {
        if (!this.accessList.containsKey(profile)) {
            this.accessList.put(profile, new HashSet());
        }
        this.accessList.get(profile).add(key);
    }

    public void givePermissions(String profile, Collection<String> keys) {
        if (!this.accessList.containsKey(profile)) {
            this.accessList.put(profile, new HashSet());
        }
        this.accessList.get(profile).addAll(keys);
    }

    public void removePermissions(String profile, Collection<String> keys) {
        if (this.accessList.containsKey(profile)) {
            this.accessList.get(profile).removeAll(keys);
        }
    }

    public void commit() {
    }
}

