/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.exoplatform.services.organization.Membership;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Identity {
    private String sessionId_;
    private String username_;
    private Subject subject_;
    private Map<String, Set<String>> groupsByMembershipMap_;

    public Identity(String sessionId, String username, String password) {
        this(sessionId, username, new Subject());
    }

    public Identity(String sessionId, String username, Subject subject) {
        this.sessionId_ = sessionId;
        this.username_ = username;
        this.subject_ = subject;
    }

    public String getSessionId() {
        return this.sessionId_;
    }

    public String getUsername() {
        return this.username_;
    }

    public Subject getSubject() {
        return this.subject_;
    }

    public boolean isInGroup(String groupId) {
        Collection<Set<String>> values = this.groupsByMembershipMap_.values();
        for (Set<String> groups : values) {
            if (!groups.contains(groupId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMembership(String membershipType, String groupId) {
        Set<String> groupsForMembership = this.groupsByMembershipMap_.get(membershipType);
        if (groupsForMembership == null) {
            return false;
        }
        return groupsForMembership.contains(groupId);
    }

    public void setMemberships(Collection<Membership> memberships) {
        if (memberships == null) {
            return;
        }
        this.groupsByMembershipMap_ = new HashMap<String, Set<String>>();
        for (Membership membership : memberships) {
            String membershipType = membership.getMembershipType();
            Set<String> groupsForMembership = this.groupsByMembershipMap_.get(membershipType);
            if (groupsForMembership == null) {
                groupsForMembership = new HashSet<String>();
                this.groupsByMembershipMap_.put(membershipType, groupsForMembership);
            }
            groupsForMembership.add(membership.getGroupId());
        }
    }
}

