/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.persistenceImp;

import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.persistence.PortletPreferencesPersister;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationProxy;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletPreferencesImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.persistenceImp.PersistenceManager;

public class DefaultPersistenceManager
implements PersistenceManager {
    private final Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
    protected ExoContainer cont;

    public DefaultPersistenceManager(ExoContainerContext context) throws Exception {
        this.cont = context.getContainer();
    }

    public final PortletWindowInternal getWindow(Input input, ExoPortletPreferences defaultPrefs) {
        WindowID windowID = input.getInternalWindowID();
        PortletApplicationProxy proxy = (PortletApplicationProxy)this.cont.getComponentInstance((Object)windowID.getPortletApplicationName());
        String validatorClassName = null;
        PreferencesValidator validator = null;
        if (defaultPrefs != null && (validatorClassName = defaultPrefs.getPreferencesValidator()) != null) {
            validator = proxy.getValidator(validatorClassName, windowID.getPortletName());
        }
        PortletPreferencesPersister currentPersister = null;
        if (input.getPortletPreferencesPersister() != null) {
            currentPersister = input.getPortletPreferencesPersister();
        } else {
            ExoContainer container = this.cont;
            currentPersister = (PortletPreferencesPersister)container.getComponentInstanceOfType(PortletPreferencesPersister.class);
        }
        PortletPreferencesImp prefsImp = null;
        if (!input.isStateSaveOnClient()) {
            try {
                ExoPortletPreferences preferences = currentPersister.getPortletPreferences(windowID);
                if (preferences != null) {
                    prefsImp = new PortletPreferencesImp(validator, defaultPrefs, windowID, currentPersister);
                    prefsImp.setCurrentPreferences(preferences);
                    return new PortletWindowInternal(windowID, (PortletPreferences)prefsImp);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"Error: ", (Throwable)ex);
            }
        } else {
            byte[] portletState = input.getPortletState();
            if (portletState != null) {
                try {
                    return new PortletWindowInternal(windowID, (PortletPreferences)IOUtil.deserialize((byte[])portletState));
                }
                catch (Exception e) {
                    this.log.error((Object)"Error: ", (Throwable)e);
                }
            }
        }
        prefsImp = new PortletPreferencesImp(validator, defaultPrefs, windowID, currentPersister);
        return new PortletWindowInternal(windowID, (PortletPreferences)prefsImp);
    }
}

