/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.helper.WindowInfosContainer;
import org.exoplatform.web.WebAppController;
import org.exoplatform.webui.application.WebuiApplication;

public class PortalSessionListener
implements HttpSessionListener {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalSessionListener");

    public void sessionCreated(HttpSessionEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent event) {
        try {
            String portalContainerName = event.getSession().getServletContext().getServletContextName();
            log.warn((Object)("Destroy session from '" + portalContainerName + "' portal"));
            RootContainer rootContainer = RootContainer.getInstance();
            PortalContainer portalContainer = rootContainer.getPortalContainer(portalContainerName);
            PortalContainer.setInstance((PortalContainer)portalContainer);
            WebAppController controller = (WebAppController)portalContainer.getComponentInstanceOfType(WebAppController.class);
            PortalApplication portalApp = (PortalApplication)controller.getApplication("PortalApplication");
            portalApp.getStateManager().expire(event.getSession().getId(), (WebuiApplication)portalApp);
            WindowInfosContainer.removeInstance((ExoContainer)portalContainer, (String)event.getSession().getId());
        }
        catch (Exception ex) {
            log.error((Object)"Error while destroying a portal session", (Throwable)ex);
        }
        finally {
            PortalContainer.setInstance(null);
        }
    }
}

