/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui;

import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/portal/webui/UILoginForm.gtmpl", events={@EventConfig(listeners={SigninActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIMaskWorkspace.CloseActionListener.class})})
public class UILoginForm
extends UIForm {
    public UILoginForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput("username", "username", null)).addUIFormInput((UIFormInput)new UIFormStringInput("password", "password", null).setType((short)1));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SigninActionListener
    extends EventListener<UILoginForm> {
        public void execute(Event<UILoginForm> event) throws Exception {
            UILoginForm uiForm = (UILoginForm)((Object)event.getSource());
            String username = (String)uiForm.getUIStringInput("username").getValue();
            String password = (String)uiForm.getUIStringInput("password").getValue();
            OrganizationService orgService = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            boolean authentication = orgService.getUserHandler().authenticate(username, password);
            if (!authentication) {
                throw new MessageException(new ApplicationMessage("UILoginForm.msg.Invalid-account", null));
            }
            PortalRequestContext prContext = Util.getPortalRequestContext();
            HttpServletRequest request = prContext.getRequest();
            request.getSession().invalidate();
            HttpSession session = request.getSession();
            session.setAttribute("authentication.username", (Object)username);
            session.setAttribute("authentication.password", (Object)password);
            prContext.setResponseComplete(true);
            UIPortal uiCurrentPortal = Util.getUIPortal();
            String portalName = uiCurrentPortal.getName();
            portalName = URLEncoder.encode(portalName, "UTF-8");
            String redirect = request.getContextPath() + "/private/" + portalName + "/";
            prContext.getResponse().sendRedirect(redirect);
        }
    }
}

