/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/webui/form/UIItemThemeSelector.gtmpl", events={@EventConfig(listeners={SelectThemeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SetDefaultActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIDropDownControl.class, id="ThemeDropDown", template="system:/groovy/webui/core/UIDropDownControl.gtmpl", events={@EventConfig(listeners={ChangeOptionActionListener.class})})})
public class UIItemThemeSelector
extends UIFormInputBase<String> {
    private String selectedTheme;
    private List<ThemeCategory> categories = new ArrayList<ThemeCategory>();
    private ThemeCategory selectedCategory;
    public static final String DEFAULT_THEME = "DefaultTheme";

    public UIItemThemeSelector(String name, String bindingField) throws Exception {
        super(name, bindingField, String.class);
        this.setComponentConfig(UIItemThemeSelector.class, null);
        this.addChild(UIDropDownControl.class, "ThemeDropDown", null);
    }

    public UIFormInput setValue(String value) {
        this.setSelectedTheme(value);
        return this;
    }

    public String getValue() {
        return this.getSelectedTheme();
    }

    public void decode(Object input, WebuiRequestContext context) throws Exception {
        String value = String.valueOf(input);
        this.selectedTheme = value.equals("null") || value.trim().length() < 1 ? null : value;
    }

    public String event(String name, String beanId) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        return uiForm.event(name, beanId);
    }

    public String event(String name) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        return uiForm.event(name);
    }

    public void reset() {
        super.reset();
        this.selectedCategory = null;
        this.selectedTheme = DEFAULT_THEME;
        ((UIDropDownControl)this.getChild(UIDropDownControl.class)).setValue(0);
    }

    public void setValues(Map<String, Set<String>> themeSet) {
        this.categories.clear();
        if (themeSet == null) {
            this.selectedCategory = null;
            this.selectedTheme = null;
            return;
        }
        for (Map.Entry<String, Set<String>> cateEntry : themeSet.entrySet()) {
            ThemeCategory category = new ThemeCategory(cateEntry.getKey());
            ArrayList themes = new ArrayList(cateEntry.getValue());
            for (String theme : themes) {
                category.addTheme(theme);
            }
            this.categories.add(category);
        }
        this.setSelectedCategory(this.categories.get(0));
        ((UIDropDownControl)this.getChild(UIDropDownControl.class)).setOptions(this.getDropDownOptions());
    }

    public ThemeCategory getSelectedCategory() {
        if (this.selectedCategory == null && this.categories.size() > 0) {
            return this.categories.get(0);
        }
        return this.selectedCategory;
    }

    public void setSelectedCategory(ThemeCategory selectedCate) {
        if (selectedCate == null) {
            this.setSelectedCategory((String)null);
            return;
        }
        String cateName = selectedCate.getName();
        this.setSelectedCategory(cateName);
    }

    public void setSelectedCategory(String cateName) {
        this.selectedCategory = null;
        if (cateName == null) {
            return;
        }
        UIDropDownControl uiDropDown = (UIDropDownControl)this.getChild(UIDropDownControl.class);
        for (ThemeCategory cate : this.categories) {
            if (!cate.getName().equals(cateName)) continue;
            this.selectedCategory = cate;
            uiDropDown.setValue(cateName);
            return;
        }
    }

    public String getSelectedTheme() {
        if (this.selectedTheme == null || this.selectedTheme.trim().length() < 1) {
            this.selectedTheme = DEFAULT_THEME;
        }
        return this.selectedTheme;
    }

    public void setSelectedTheme(String value) {
        this.selectedTheme = null;
        for (ThemeCategory cate : this.categories) {
            List<String> themes = cate.getThemes();
            if (themes == null) continue;
            for (String theme : themes) {
                if (!theme.equals(value)) continue;
                this.selectedTheme = value;
                this.setSelectedCategory(cate);
                return;
            }
        }
    }

    public List<ThemeCategory> getCategories() {
        if (this.categories == null) {
            return new ArrayList<ThemeCategory>();
        }
        return this.categories;
    }

    public void setCategories(List<ThemeCategory> list) {
        this.categories = list;
        ((UIDropDownControl)this.getChild(UIDropDownControl.class)).setOptions(this.getDropDownOptions());
    }

    private List<SelectItemOption<String>> getDropDownOptions() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        if (this.categories != null) {
            for (ThemeCategory ele : this.categories) {
                String cateName = ele.getName();
                options.add((SelectItemOption<String>)new SelectItemOption(cateName, (Object)cateName));
            }
        }
        return options;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThemeCategory {
        private String name_;
        private String description_;
        private List<String> themes_;

        public ThemeCategory(String name) {
            this.name_ = name;
            this.description_ = name;
        }

        public ThemeCategory(String name, String description) {
            this.name_ = name;
            this.description_ = description;
        }

        public String getName() {
            return this.name_;
        }

        public void setName(String name) {
            this.name_ = name;
        }

        public String getDescription() {
            return this.description_;
        }

        public void setDescription(String description) {
            this.description_ = description;
        }

        public List<String> getThemes() {
            return this.themes_;
        }

        public void setThemes(List<String> themes) {
            this.themes_ = themes;
        }

        public void addTheme(String theme) {
            if (this.themes_ == null) {
                this.themes_ = new ArrayList<String>();
            }
            this.themes_.add(theme);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDefaultActionListener
    extends EventListener<UIItemThemeSelector> {
        public void execute(Event<UIItemThemeSelector> event) throws Exception {
            UIItemThemeSelector uiFormInput = (UIItemThemeSelector)((Object)event.getSource());
            uiFormInput.reset();
            UIForm uiForm = (UIForm)uiFormInput.getAncestorOfType(UIForm.class);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeOptionActionListener
    extends EventListener<UIDropDownControl> {
        public void execute(Event<UIDropDownControl> event) throws Exception {
            UIDropDownControl uiDropDown = (UIDropDownControl)event.getSource();
            String category = event.getRequestContext().getRequestParameter("objectId");
            UIItemThemeSelector uiFormInput = (UIItemThemeSelector)uiDropDown.getParent();
            uiFormInput.setSelectedCategory(category);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiFormInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectThemeActionListener
    extends EventListener<UIItemThemeSelector> {
        public void execute(Event<UIItemThemeSelector> event) throws Exception {
            UIItemThemeSelector uiFormInput = (UIItemThemeSelector)((Object)event.getSource());
            String theme = event.getRequestContext().getRequestParameter("objectId");
            uiFormInput.setSelectedTheme(theme);
            UIForm uiForm = (UIForm)uiFormInput.getAncestorOfType(UIForm.class);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

