/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.application.EventsWrapper;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.application.UIPortletForm;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.pci.ActionInput;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.EventInput;
import org.exoplatform.services.portletcontainer.pci.EventOutput;
import org.exoplatform.services.portletcontainer.pci.ResourceInput;
import org.exoplatform.services.portletcontainer.pci.ResourceOutput;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPortletActionListener {
    public static final String PORTLET_EVENTS = "PortletEvents";
    protected static Log log = ExoLogger.getLogger((String)"portal:UIPortletActionListener");

    public static void setNextState(UIPortlet uiPortlet, WindowState state) {
        if (state != null) {
            UIPage uiPage = (UIPage)uiPortlet.getAncestorOfType(UIPage.class);
            if (state == WindowState.MAXIMIZED) {
                uiPortlet.setCurrentWindowState(WindowState.MAXIMIZED);
                if (uiPage != null) {
                    uiPage.setMaximizedUIPortlet(uiPortlet);
                }
            } else if (state == WindowState.MINIMIZED) {
                uiPortlet.setCurrentWindowState(WindowState.MINIMIZED);
                if (uiPage != null) {
                    uiPage.setMaximizedUIPortlet(null);
                }
            } else {
                uiPortlet.setCurrentWindowState(WindowState.NORMAL);
                if (uiPage != null) {
                    uiPage.setMaximizedUIPortlet(null);
                }
            }
        }
    }

    public static void setNextMode(UIPortlet uiPortlet, PortletMode portletMode) {
        if (portletMode != null) {
            if (portletMode.equals((Object)PortletMode.HELP.toString())) {
                uiPortlet.setCurrentPortletMode(PortletMode.HELP);
            } else if (portletMode.equals((Object)PortletMode.EDIT.toString())) {
                uiPortlet.setCurrentPortletMode(PortletMode.EDIT);
            } else {
                uiPortlet.setCurrentPortletMode(PortletMode.VIEW);
            }
        }
    }

    private static Map getResourceParameterMap(UIPortlet uiPortlet, PortalRequestContext prcontext) {
        Map<String, String[]> renderParams;
        HashMap<String, String[]> portletParams = new HashMap<String, String[]>(prcontext.getPortletParameters());
        String cacheLevel = prcontext.getCacheLevel();
        if (("cacheLevelPage".equals(cacheLevel) || "cacheLevelPortlet".equals(cacheLevel)) && (renderParams = uiPortlet.getRenderParametersMap()) != null) {
            Set<String> keys = renderParams.keySet();
            for (String key : keys) {
                if (portletParams.containsKey(key)) {
                    String[] renderValueArray = renderParams.get(key);
                    String[] portletValueArray = (String[])portletParams.get(key);
                    String[] resources = new String[renderValueArray.length + portletValueArray.length];
                    System.arraycopy(portletValueArray, 0, resources, 0, portletValueArray.length);
                    System.arraycopy(renderValueArray, 0, resources, portletValueArray.length, renderValueArray.length);
                    portletParams.put(key, resources);
                    continue;
                }
                portletParams.put(key, renderParams.get(key));
            }
            portletParams.putAll(renderParams);
        }
        return portletParams;
    }

    public static List<javax.portlet.Event> processEvent(UIPortlet uiPortlet, javax.portlet.Event event) {
        log.info((Object)("Process Event: " + event.getName() + " for portlet: " + uiPortlet.getWindowId()));
        try {
            PortletContainerService service = (PortletContainerService)uiPortlet.getApplicationComponent(PortletContainerService.class);
            PortalRequestContext context = (PortalRequestContext)WebuiRequestContext.getCurrentInstance();
            EventInput input = new EventInput();
            String baseUrl = context.getNodeURI() + "?portal:componentId" + "=" + uiPortlet.getId();
            input.setBaseURL(baseUrl);
            UIPortal uiPortal = Util.getUIPortal();
            OrganizationService organizationService = (OrganizationService)uiPortlet.getApplicationComponent(OrganizationService.class);
            UserProfile userProfile = organizationService.getUserProfileHandler().findUserProfileByName(uiPortal.getOwner());
            if (userProfile != null) {
                input.setUserAttributes(userProfile.getUserInfoMap());
            } else {
                input.setUserAttributes(new HashMap());
            }
            input.setPortletMode(uiPortlet.getCurrentPortletMode());
            input.setWindowState(uiPortlet.getCurrentWindowState());
            input.setInternalWindowID((WindowID)uiPortlet.getExoWindowID());
            input.setMarkup("text/html");
            input.setEvent(event);
            EventOutput output = service.processEvent(context.getRequest(), context.getResponse(), input);
            UIPortletActionListener.setNextState(uiPortlet, output.getNextState());
            UIPortletActionListener.setNextMode(uiPortlet, output.getNextMode());
            return output.getEvents();
        }
        catch (Exception e) {
            log.error((Object)("Problem while processesing event for the portlet: " + uiPortlet.getWindowId()), (Throwable)e);
            return null;
        }
    }

    public static void setupPublicRenderParams(UIPortlet uiPortlet, Map<String, String[]> requestParams) {
        UIPortal uiPortal = Util.getUIPortal();
        Map<String, String[]> publicParams = uiPortal.getPublicParameters();
        for (String key : requestParams.keySet()) {
            if (!uiPortlet.supportsPublicParam(key)) continue;
            publicParams.put(key, requestParams.get(key));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditPortletActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            UIPortletForm uiPortletForm = uiMaskWS.createUIComponent(UIPortletForm.class, null, null);
            uiPortletForm.setValues(uiPortlet);
            uiMaskWS.setWindowSize(800, -1);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangePortletModeActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            String portletMode = event.getRequestContext().getRequestParameter("portal:portletMode");
            if (portletMode == null) {
                portletMode = event.getRequestContext().getRequestParameter("objectId");
            }
            log.info((Object)("Change portlet mode of " + uiPortlet.getWindowId() + " to " + portletMode));
            if (portletMode.equals(PortletMode.HELP.toString())) {
                uiPortlet.setCurrentPortletMode(PortletMode.HELP);
            } else if (portletMode.equals(PortletMode.EDIT.toString())) {
                uiPortlet.setCurrentPortletMode(PortletMode.EDIT);
            } else {
                uiPortlet.setCurrentPortletMode(PortletMode.VIEW);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortlet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeWindowStateActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet maxPortlet;
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortlet.getAncestorOfType(UIPortalApplication.class);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
            String windowState = event.getRequestContext().getRequestParameter("portal:windowState");
            if (windowState == null) {
                windowState = event.getRequestContext().getRequestParameter("objectId").trim();
            }
            UIPageBody uiPageBody = (UIPageBody)uiPortlet.getAncestorOfType(UIPageBody.class);
            UIPage uiPage = (UIPage)uiPortlet.getAncestorOfType(UIPage.class);
            if (windowState.equals(WindowState.MAXIMIZED.toString())) {
                if (uiPageBody != null) {
                    uiPortlet.setCurrentWindowState(WindowState.MAXIMIZED);
                    if (uiPage != null && uiPage.isShowMaxWindow()) {
                        uiPage.setMaximizedUIPortlet(uiPortlet);
                    }
                    uiPageBody.setMaximizedUIComponent(uiPortlet);
                } else {
                    uiPortlet.setCurrentWindowState(WindowState.NORMAL);
                }
                return;
            }
            if (uiPageBody != null && (maxPortlet = (UIPortlet)uiPageBody.getMaximizedUIComponent()) == uiPortlet) {
                uiPageBody.setMaximizedUIComponent(null);
            }
            if (uiPage != null && (maxPortlet = uiPage.getMaximizedUIPortlet()) == uiPortlet) {
                uiPage.setMaximizedUIPortlet(null);
            }
            if (windowState.equals(WindowState.MINIMIZED.toString())) {
                uiPortlet.setCurrentWindowState(WindowState.MINIMIZED);
                return;
            }
            uiPortlet.setCurrentWindowState(WindowState.NORMAL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenderActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            uiPortlet.setRenderParametersMap(null);
            HttpServletRequest request = (HttpServletRequest)event.getRequestContext().getRequest();
            UIPortletActionListener.setupPublicRenderParams(uiPortlet, request.getParameterMap());
            Map<String, String[]> renderParams = ((PortalRequestContext)event.getRequestContext()).getPortletParameters();
            uiPortlet.setRenderParametersMap(renderParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessEventsActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            PortalRequestContext context = (PortalRequestContext)event.getRequestContext();
            ArrayList porletInstancesInPage = new ArrayList();
            UIPortalApplication uiPortal = (UIPortalApplication)uiPortlet.getAncestorOfType(UIPortalApplication.class);
            uiPortal.findComponentOfType(porletInstancesInPage, UIPortlet.class);
            EventsWrapper eventsWrapper = (EventsWrapper)event.getRequestContext().getAttribute(UIPortletActionListener.PORTLET_EVENTS);
            List<javax.portlet.Event> events = eventsWrapper.getEvents();
            for (javax.portlet.Event nativeEvent : events) {
                QName eventName = nativeEvent.getQName();
                for (UIPortlet uiPortletInPage : porletInstancesInPage) {
                    if (!uiPortletInPage.supportsProcessingEvent(eventName) || eventsWrapper.isInvokedTooManyTimes(uiPortletInPage.getWindowId())) continue;
                    List<javax.portlet.Event> newEvents = UIPortletActionListener.processEvent(uiPortletInPage, nativeEvent);
                    eventsWrapper.increaseCounter(uiPortletInPage.getWindowId());
                    if (context.useAjax()) {
                        log.info((Object)"Events where generated inside the scope of an AJAX call, hence will only refresh the targeted portlets");
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortletInPage);
                    } else {
                        log.info((Object)"Events where generated outside the scope of an AJAX call, hence will make a full render of the page");
                        context.setFullRender(true);
                    }
                    if (newEvents == null || newEvents.isEmpty()) continue;
                    log.info((Object)("The portlet: " + uiPortletInPage.getWindowId() + " processEvent() method has generated new events itself"));
                    events.addAll(newEvents);
                    uiPortlet.createEvent("ProcessEvents", Event.Phase.PROCESS, context).broadcast();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServeResourceActionListener
    extends EventListener<UIPortlet> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            log.info((Object)("Serve Resource for portlet: " + uiPortlet.getWindowId()));
            try {
                ExoContainer container = event.getRequestContext().getApplication().getApplicationServiceContainer();
                UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortlet.getAncestorOfType(UIPortalApplication.class);
                PortletContainerService portletContainer = (PortletContainerService)container.getComponentInstanceOfType(PortletContainerService.class);
                ResourceInput input = new ResourceInput();
                OrganizationService service = (OrganizationService)uiPortlet.getApplicationComponent(OrganizationService.class);
                UserProfile userProfile = service.getUserProfileHandler().findUserProfileByName(uiPortalApp.getOwner());
                input.setInternalWindowID((WindowID)uiPortlet.getExoWindowID());
                if (userProfile != null) {
                    input.setUserAttributes(userProfile.getUserInfoMap());
                } else {
                    input.setUserAttributes(new HashMap());
                }
                input.setPortletMode(uiPortlet.getCurrentPortletMode());
                input.setWindowState(uiPortlet.getCurrentWindowState());
                input.setMarkup("text/html");
                PortalRequestContext context = (PortalRequestContext)event.getRequestContext();
                input.setRenderParameters(UIPortletActionListener.getResourceParameterMap(uiPortlet, context));
                input.setCacheability(context.getCacheLevel());
                String baseUrl = context.getNodeURI() + "?portal:componentId" + "=" + uiPortlet.getId();
                input.setBaseURL(baseUrl);
                HttpServletRequest request = context.getRequest();
                HttpServletResponse response = context.getResponse();
                String resourceId = request.getParameter("portal:resourceID");
                if (resourceId != null) {
                    input.setResourceID(resourceId);
                }
                ResourceOutput output = portletContainer.serveResource(request, context.getResponse(), input);
                context.setHeaders(output.getHeaderProperties());
                if (resourceId != null) {
                    return;
                }
                String contentType = output.getContentType();
                log.info((Object)("Try to get a resource of type: " + contentType + " for the portlet: " + uiPortlet.getWindowId()));
                if (contentType.startsWith("text")) {
                    context.getWriter().write(output.getContent());
                } else {
                    response.setContentType(contentType);
                    ServletOutputStream stream = response.getOutputStream();
                    stream.write(output.getBinContent());
                }
                context.getResponse().flushBuffer();
            }
            catch (Exception e) {
                log.error((Object)("Problem while serving resource for the portlet: " + uiPortlet.getWindowId()), (Throwable)e);
            }
            finally {
                event.getRequestContext().setResponseComplete(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessActionActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            PortalRequestContext prcontext = (PortalRequestContext)event.getRequestContext();
            ExoContainer container = event.getRequestContext().getApplication().getApplicationServiceContainer();
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortlet.getAncestorOfType(UIPortalApplication.class);
            PortletContainerService portletContainer = (PortletContainerService)container.getComponentInstanceOfType(PortletContainerService.class);
            ActionInput actionInput = new ActionInput();
            OrganizationService service = (OrganizationService)uiPortlet.getApplicationComponent(OrganizationService.class);
            UserProfile userProfile = service.getUserProfileHandler().findUserProfileByName(uiPortalApp.getOwner());
            actionInput.setInternalWindowID((WindowID)uiPortlet.getExoWindowID());
            if (userProfile != null) {
                actionInput.setUserAttributes(userProfile.getUserInfoMap());
            } else {
                actionInput.setUserAttributes(new HashMap());
            }
            HashMap allParams = new HashMap();
            allParams.putAll(prcontext.getRequest().getParameterMap());
            actionInput.setRenderParameters(allParams);
            actionInput.setPortletMode(uiPortlet.getCurrentPortletMode());
            actionInput.setWindowState(uiPortlet.getCurrentWindowState());
            actionInput.setMarkup("text/html");
            actionInput.setStateChangeAuthorized(true);
            ActionOutput output = portletContainer.processAction(prcontext.getRequest(), prcontext.getResponse(), actionInput);
            UIPortletActionListener.setNextState(uiPortlet, output.getNextState());
            UIPortletActionListener.setNextMode(uiPortlet, output.getNextMode());
            HttpServletRequest request = (HttpServletRequest)event.getRequestContext().getRequest();
            UIPortletActionListener.setupPublicRenderParams(uiPortlet, request.getParameterMap());
            uiPortlet.setRenderParametersMap(output.getRenderParameters());
            List events = output.getEvents();
            if (events != null) {
                prcontext.setAttribute(UIPortletActionListener.PORTLET_EVENTS, new EventsWrapper(events));
                uiPortlet.createEvent("ProcessEvents", Event.Phase.PROCESS, prcontext).broadcast();
            }
        }
    }
}

