/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.ExceptionUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPortletLifecycle
extends Lifecycle {
    protected static Log log = ExoLogger.getLogger((String)"portal:UIPortletLifecycle");

    public void processAction(UIComponent uicomponent, WebuiRequestContext context) throws Exception {
        String portletActionType;
        String windowState;
        String action = context.getRequestParameter("portal:action");
        if (action != null) {
            Event event = uicomponent.createEvent(action, Event.Phase.PROCESS, context);
            if (event != null) {
                event.broadcast();
            }
            return;
        }
        boolean addUpdateComponent = false;
        String portletMode = context.getRequestParameter("portal:portletMode");
        if (portletMode != null) {
            Event event = uicomponent.createEvent("ChangePortletMode", Event.Phase.PROCESS, context);
            if (event != null) {
                event.broadcast();
            }
            addUpdateComponent = true;
        }
        if ((windowState = context.getRequestParameter("portal:windowState")) != null) {
            Event event = uicomponent.createEvent("ChangeWindowState", Event.Phase.PROCESS, context);
            if (event != null) {
                event.broadcast();
            }
            addUpdateComponent = true;
        }
        if ((portletActionType = context.getRequestParameter("portal:type")) != null) {
            if (portletActionType.equals("action")) {
                Event event = uicomponent.createEvent("ProcessAction", Event.Phase.PROCESS, context);
                if (event != null) {
                    event.broadcast();
                }
                addUpdateComponent = true;
            } else if (portletActionType.equals("resource")) {
                Event event = uicomponent.createEvent("ServeResource", Event.Phase.PROCESS, context);
                if (event != null) {
                    event.broadcast();
                }
            } else {
                Event event = uicomponent.createEvent("Render", Event.Phase.PROCESS, context);
                if (event != null) {
                    event.broadcast();
                }
                addUpdateComponent = true;
            }
        }
        if (addUpdateComponent) {
            context.addUIComponentToUpdateByAjax(uicomponent);
        }
    }

    public void processRender(UIComponent uicomponent, WebuiRequestContext context) throws Exception {
        UIPortlet uiPortlet = (UIPortlet)uicomponent;
        PortalRequestContext prcontext = (PortalRequestContext)context;
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        UIPortal uiPortal = Util.getUIPortal();
        PortletContainerService portletContainer = (PortletContainerService)container.getComponentInstanceOfType(PortletContainerService.class);
        OrganizationService service = (OrganizationService)uicomponent.getApplicationComponent(OrganizationService.class);
        UserProfile userProfile = service.getUserProfileHandler().findUserProfileByName(uiPortal.getOwner());
        RenderInput input = new RenderInput();
        String baseUrl = prcontext.getNodeURI() + "?portal:componentId" + "=" + uiPortlet.getId();
        input.setBaseURL(baseUrl);
        if (userProfile != null) {
            input.setUserAttributes(userProfile.getUserInfoMap());
        } else {
            input.setUserAttributes(new HashMap());
        }
        input.setPortletMode(uiPortlet.getCurrentPortletMode());
        input.setWindowState(uiPortlet.getCurrentWindowState());
        input.setMarkup("text/html");
        input.setTitle(uiPortlet.getTitle());
        input.setInternalWindowID((WindowID)uiPortlet.getExoWindowID());
        input.setRenderParameters(this.getRenderParameterMap(uiPortlet));
        input.setPublicParamNames(uiPortlet.getPublicRenderParamNames());
        RenderOutput output = null;
        StringBuilder portletContent = new StringBuilder();
        String portletTitle = null;
        try {
            if (uiPortlet.getCurrentWindowState() != WindowState.MINIMIZED) {
                output = portletContainer.render(prcontext.getRequest(), prcontext.getResponse(), input);
                if (output.getContent() == null) {
                    portletContent.append("EXO-ERROR: Portlet container throw an exception\n").append(uiPortlet.getId()).append(" has error");
                } else {
                    portletContent.setLength(0);
                    portletContent.append(output.getContent());
                }
            }
        }
        catch (Throwable ex) {
            ex = ExceptionUtil.getRootCause((Throwable)ex);
            portletContent.append(ExceptionUtil.getStackTrace((Throwable)ex, (int)100));
            log.error((Object)"Exception print in the portlet content", ex);
        }
        if (output != null) {
            portletTitle = output.getTitle();
            prcontext.setHeaders(output.getHeaderProperties());
        }
        if (portletTitle == null) {
            portletTitle = "Portlet";
        }
        if (context.useAjax() && !prcontext.getFullRender()) {
            context.getWriter().write(portletContent.toString());
        } else {
            WebuiApplication app = (WebuiApplication)context.getApplication();
            ApplicationResourceResolver resolver = app.getResourceResolver();
            WebuiBindingContext bcontext = new WebuiBindingContext((ResourceResolver)resolver, context.getWriter(), uicomponent, context);
            bcontext.put((Object)"uicomponent", (Object)uicomponent);
            bcontext.put((Object)"portletContent", (Object)portletContent);
            bcontext.put((Object)"portletTitle", (Object)portletTitle);
            try {
                this.renderTemplate(uicomponent.getTemplate(), bcontext);
            }
            catch (Throwable ex) {
                ex = ExceptionUtil.getRootCause((Throwable)ex);
                portletContent.append(ExceptionUtil.getStackTrace((Throwable)ex, (int)100));
                log.error((Object)"Exception print in the portlet content", ex);
            }
        }
        try {
            prcontext.getResponse().flushBuffer();
        }
        catch (Throwable ex) {
            ex = ExceptionUtil.getRootCause((Throwable)ex);
            portletContent.append(ExceptionUtil.getStackTrace((Throwable)ex, (int)100));
            log.error((Object)"Exception print in the portlet content", ex);
        }
    }

    private Map<String, String[]> getRenderParameterMap(UIPortlet uiPortlet) {
        Map<String, String[]> renderParams = uiPortlet.getRenderParametersMap();
        if (renderParams == null) {
            renderParams = new HashMap<String, String[]>();
            uiPortlet.setRenderParametersMap(renderParams);
        }
        HashMap<String, String[]> allParams = new HashMap<String, String[]>(renderParams);
        allParams.putAll(uiPortlet.getPublicParameters());
        return allParams;
    }
}

