/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/portal/webui/application/UIPortletOptions.gtmpl"), @ComponentConfig(type=UIDropDownControl.class, id="UIDropDownPorletOptions", template="system:/groovy/webui/core/UIDropDownControl.gtmpl", events={@EventConfig(listeners={ChangeOptionActionListener.class})})})
public class UIPortletOptions
extends UIContainer {
    private List<PortletCategoryData> pCategoryDatas;
    private ApplicationCategory selectedPCategory;

    public UIPortletOptions() throws Exception {
        this.setId("UIPortletOptions");
        this.pCategoryDatas = new ArrayList<PortletCategoryData>();
        UIDropDownControl dropCategorys = (UIDropDownControl)this.addChild(UIDropDownControl.class, "UIDropDownPorletOptions", "UIDropDownPorletOptions");
        dropCategorys.setParent((UIComponent)this);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        dropCategorys.setOptions(options);
        ApplicationRegistryService service = (ApplicationRegistryService)this.getApplicationComponent(ApplicationRegistryService.class);
        String remoteUser = RequestContext.getCurrentInstance().getRemoteUser();
        List pCategories = service.getApplicationCategories(remoteUser, new String[]{"portlet"});
        Collections.sort(pCategories, new PortletCategoryComparator());
        PortletComparator portletComparator = new PortletComparator();
        for (ApplicationCategory pCategory : pCategories) {
            List portlets = pCategory.getApplications();
            if (this.selectedPCategory == null) {
                this.selectedPCategory = pCategory;
            }
            Collections.sort(portlets, portletComparator);
            this.pCategoryDatas.add(new PortletCategoryData(pCategory, portlets));
        }
        for (PortletCategoryData categoryData : this.pCategoryDatas) {
            categoryData.getPortlets();
            options.add(new SelectItemOption((Object)categoryData.getPortletCategory().getName()));
        }
    }

    public String removeStringPortlet(String name) {
        int index = name.lastIndexOf("Portlet");
        if (index != 0 && index != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    public Application getPortlet(String id) throws Exception {
        for (PortletCategoryData category : this.pCategoryDatas) {
            List<Application> items = category.getPortlets();
            for (Application item : items) {
                if (!item.getId().equals(id)) continue;
                return item;
            }
        }
        return null;
    }

    public ApplicationCategory getSelectedPCategory() {
        return this.selectedPCategory;
    }

    public void setCategorySelected(String selectedContainerId) {
        for (PortletCategoryData categoryData : this.pCategoryDatas) {
            if (!categoryData.getPortletCategory().getName().equals(selectedContainerId)) continue;
            this.selectedPCategory = categoryData.getPortletCategory();
        }
    }

    public List<PortletCategoryData> getPortletCategorDatas() {
        return this.pCategoryDatas;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
        Util.showComponentLayoutMode(UIPortlet.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeOptionActionListener
    extends EventListener<UIDropDownControl> {
        public void execute(Event<UIDropDownControl> event) throws Exception {
            String selectedContainerId = event.getRequestContext().getRequestParameter("objectId");
            UIDropDownControl uiDropDown = (UIDropDownControl)event.getSource();
            UIPortletOptions uiPortletOptions = (UIPortletOptions)uiDropDown.getParent();
            uiDropDown.setValue(selectedContainerId);
            uiPortletOptions.setCategorySelected(selectedContainerId);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPortletOptions.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PortletCategoryData {
        private ApplicationCategory portletCategory;
        private List<Application> portlets;

        public PortletCategoryData(ApplicationCategory portletCategory, List<Application> portlets) {
            this.portletCategory = portletCategory;
            this.portlets = portlets;
        }

        public ApplicationCategory getPortletCategory() {
            return this.portletCategory;
        }

        public List<Application> getPortlets() {
            return this.portlets;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortletComparator
    implements Comparator<Application> {
        PortletComparator() {
        }

        @Override
        public int compare(Application p1, Application p2) {
            return p1.getApplicationName().compareTo(p2.getApplicationName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortletCategoryComparator
    implements Comparator<ApplicationCategory> {
        PortletCategoryComparator() {
        }

        @Override
        public int compare(ApplicationCategory cat1, ApplicationCategory cat2) {
            return cat1.getName().compareTo(cat2.getName());
        }
    }
}

