/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.webui.application.UIWidgetContainerManagement;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIWidgetContainerForm
extends UIForm {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_DESC = "description";
    private Container container_;

    public UIWidgetContainerForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DESC, FIELD_DESC, null));
    }

    public void setValue(Container container) throws Exception {
        this.container_ = container;
        this.reset();
        if (this.container_ == null) {
            return;
        }
        this.invokeGetBindingBean(this.container_);
    }

    public Container getContainer() {
        return this.container_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIWidgetContainerForm> {
        public void execute(Event<UIWidgetContainerForm> event) throws Exception {
            UIWidgetContainerForm uiForm = (UIWidgetContainerForm)((Object)event.getSource());
            uiForm.setValue(null);
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIWidgetContainerForm> {
        public void execute(Event<UIWidgetContainerForm> event) throws Exception {
            UIWidgetContainerForm uiForm = (UIWidgetContainerForm)((Object)event.getSource());
            WebuiRequestContext rcontext = event.getRequestContext();
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            UIWidgetContainerManagement uiManagement = (UIWidgetContainerManagement)uiPopup.getParent();
            Container container = uiForm.getContainer();
            if (container == null) {
                container = new Container();
            }
            uiForm.invokeSetBindingBean(container);
            if (container != uiForm.getContainer()) {
                container.setId(StringUtils.deleteWhitespace((String)container.getName()));
                List<Container> existingContainers = uiManagement.getContainers();
                if (existingContainers != null) {
                    for (Container ele : existingContainers) {
                        if (!ele.getId().equals(container.getId())) continue;
                        UIPortalApplication uiPortalApp = (UIPortalApplication)uiManagement.getAncestorOfType(UIPortalApplication.class);
                        uiPortalApp.addMessage(new ApplicationMessage("UIWidgetContainerForm.msg.exist", null));
                        rcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                        return;
                    }
                }
                uiManagement.addContainer(container);
            }
            uiForm.setValue(null);
            uiPopup.setShow(false);
            uiManagement.setSelectedContainer(container);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManagement);
        }
    }
}

