/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.navigation.UIPageManagement;
import org.exoplatform.portal.webui.navigation.UIPageNavigationControlBar;
import org.exoplatform.portal.webui.navigation.UIPageNavigationForm;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPageNavigationActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveNavigationActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            UIRightClickPopupMenu uiPopup = (UIRightClickPopupMenu)event.getSource();
            UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPopup.getAncestorOfType(UIPageNodeSelector.class);
            WebuiRequestContext rcontext = event.getRequestContext();
            UIPageManagement uiManagement = (UIPageManagement)uiNodeSelector.getParent();
            List<PageNavigation> navs = uiNodeSelector.getPageNavigations();
            if (navs == null || navs.size() < 1) {
                UIPortalApplication uiApp = (UIPortalApplication)uiManagement.getAncestorOfType(UIPortalApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPageNavigationControlBar.msg.noEditablePageNavigation", (Object[])new String[0]));
                rcontext.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            PageNavigation navigation = uiNodeSelector.getSelectedNavigation();
            if (navigation == null) {
                return;
            }
            UserPortalConfigService dataService = (UserPortalConfigService)uiManagement.getApplicationComponent(UserPortalConfigService.class);
            PageNavigation oldNavigation = dataService.getPageNavigation(navigation.getId());
            if (oldNavigation == null) {
                dataService.create(navigation);
            } else {
                dataService.update(navigation);
            }
            rcontext.addUIComponentToUpdateByAjax((UIComponent)uiManagement);
            List<PageNavigation> pnavigations = Util.getUIPortal().getNavigations();
            for (int i = 0; i < pnavigations.size(); ++i) {
                if (!pnavigations.get(i).getId().equals(navigation.getId())) continue;
                pnavigations.set(i, navigation);
                return;
            }
            pnavigations.add(navigation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteNavigationActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            UIRightClickPopupMenu uiPopup = (UIRightClickPopupMenu)event.getSource();
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)uiPopup.getAncestorOfType(UIPageNodeSelector.class);
            PageNavigation selectedNavigation = uiPageNodeSelector.getSelectedNavigation();
            if (!selectedNavigation.getOwnerType().equals("group")) {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.deleteNav", null, 0));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiPageNodeSelector.deletePageNavigation(selectedNavigation);
            if (uiPageNodeSelector.getPageNavigations().size() < 1) {
                UIPageManagement uiManagement = (UIPageManagement)uiPageNodeSelector.getParent();
                Class[] childrenToRender = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
                uiManagement.setRenderedChildrenOfTypes(childrenToRender);
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiManagement);
                return;
            }
            UITree uiTree = (UITree)uiPageNodeSelector.getChild(UITree.class);
            uiTree.createEvent("ChangeNode", event.getExecutionPhase(), (WebuiRequestContext)pcontext).broadcast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditNavigationActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            UIRightClickPopupMenu uiControlBar = (UIRightClickPopupMenu)event.getSource();
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPageNavigationForm uiNavigationForm = uiMaskWS.createUIComponent(UIPageNavigationForm.class, null, null);
            UIPageManagement uiManagement = (UIPageManagement)uiControlBar.getAncestorOfType(UIPageManagement.class);
            UIPageNodeSelector uiNavigationSelector = (UIPageNodeSelector)uiManagement.findFirstComponentOfType(UIPageNodeSelector.class);
            PageNavigation nav = uiNavigationSelector.getSelectedNavigation();
            if (nav == null) {
                uiApp.addMessage(new ApplicationMessage("UIPageNavigationControlBar.msg.noEditablePageNavigation", (Object[])new String[0]));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiNavigationForm.setValues(nav);
            uiMaskWS.setUIComponent((UIComponent)uiNavigationForm);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManagement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateNavigationActionListener
    extends EventListener<UIPageNodeSelector> {
        public void execute(Event<UIPageNodeSelector> event) throws Exception {
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UserPortalConfigService service = (UserPortalConfigService)uiPortal.getApplicationComponent(UserPortalConfigService.class);
            if (service.getMakableNavigations(event.getRequestContext().getRemoteUser()).size() < 1) {
                uiApp.addMessage(new ApplicationMessage("UIPageNavigation.msg.noMakablePageNavigation", (Object[])new String[0]));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPageNavigationForm uiNavigationForm = uiMaskWS.createUIComponent(UIPageNavigationForm.class, null, null);
            uiMaskWS.setUIComponent((UIComponent)uiNavigationForm);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }
}

