/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPageNavigationForm
extends UIForm {
    protected PageNavigation pageNav_;

    public UIPageNavigationForm() throws Exception {
        PortalRequestContext pContext = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
        UserPortalConfigService dataService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        List list = dataService.getMakableNavigations(pContext.getRemoteUser());
        ArrayList<SelectItemOption> makableGroups = new ArrayList<SelectItemOption>();
        for (String ele : list) {
            makableGroups.add(new SelectItemOption((Object)ele));
        }
        UIFormSelectBox uiSelectBoxOwnerId = new UIFormSelectBox("ownerId", "ownerId", makableGroups);
        ArrayList<SelectItemOption> priorties = new ArrayList<SelectItemOption>();
        for (int i = 1; i < 11; ++i) {
            priorties.add(new SelectItemOption(String.valueOf(i), (Object)String.valueOf(i)));
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput("ownerType", "ownerType", "group").setEditable(false)).addUIFormInput((UIFormInput)uiSelectBoxOwnerId).addUIFormInput((UIFormInput)new UIFormStringInput("creator", "creator", pContext.getRemoteUser()).setEditable(false)).addUIFormInput((UIFormInput)new UIFormStringInput("modifier", "modifier", null).setEditable(false)).addUIFormInput((UIFormInput)new UIFormTextAreaInput("description", "description", null)).addUIFormInput((UIFormInput)new UIFormSelectBox("priority", null, priorties));
    }

    public void setValues(PageNavigation pageNavigation) throws Exception {
        this.pageNav_ = pageNavigation;
        this.invokeGetBindingBean(pageNavigation);
        this.removeChildById("ownerId");
        this.getUIStringInput("creator").setValue((Object)pageNavigation.getCreator());
        UIFormStringInput ownerId = new UIFormStringInput("ownerId", "ownerId", pageNavigation.getOwnerId());
        ownerId.setEditable(false);
        ownerId.setParent((UIComponent)this);
        this.getChildren().add(1, ownerId);
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById("priority");
        uiSelectBox.setValue(String.valueOf(pageNavigation.getPriority()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPageNavigationForm> {
        public void execute(Event<UIPageNavigationForm> event) throws Exception {
            UIPageNavigationForm uiForm = (UIPageNavigationForm)((Object)event.getSource());
            PageNavigation pageNav = uiForm.pageNav_;
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            if (pageNav != null) {
                uiForm.invokeSetBindingBean(pageNav);
                UIFormSelectBox uiSelectBox = (UIFormSelectBox)uiForm.findComponentById("priority");
                int priority = Integer.parseInt((String)uiSelectBox.getValue());
                pageNav.setPriority(priority);
                pageNav.setModifier(pcontext.getRemoteUser());
                UIComponentDecorator uiFormParent = (UIComponentDecorator)uiForm.getParent();
                uiFormParent.setUIComponent(null);
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiFormParent);
                return;
            }
            pageNav = new PageNavigation();
            uiForm.invokeSetBindingBean(pageNav);
            UIFormSelectBox uiSelectBox = (UIFormSelectBox)uiForm.findComponentById("priority");
            int priority = Integer.parseInt((String)uiSelectBox.getValue());
            pageNav.setPriority(priority);
            pageNav.setModifiable(true);
            pageNav.setCreator(pcontext.getRemoteUser());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiForm.getAncestorOfType(UIPortalApplication.class);
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)uiPortalApp.findFirstComponentOfType(UIPageNodeSelector.class);
            PageNavigation existingNavi = uiPageNodeSelector.getPageNavigation(pageNav.getId());
            if (existingNavi != null || this.checkExiting(pageNav.getId())) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageNavigationForm.msg.existPageNavigation", (Object[])new String[]{pageNav.getOwnerId()}));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            uiPageNodeSelector.addPageNavigation(pageNav);
            uiPageNodeSelector.selectNavigation(pageNav.getId());
            pcontext.addUIComponentToUpdateByAjax(uiPageNodeSelector.getParent());
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWS.setUIComponent(null);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }

        private boolean checkExiting(String navId) throws Exception {
            UIPortal portal = Util.getUIPortal();
            DataStorage service = (DataStorage)portal.getApplicationComponent(DataStorage.class);
            List<PageNavigation> list = portal.getNavigations();
            if (service.getPageNavigation(navId) == null) {
                return false;
            }
            for (PageNavigation nav : list) {
                if (!nav.getId().equals(navId)) continue;
                return false;
            }
            return true;
        }
    }
}

