/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.WindowState;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPortalNavigation
extends UIComponent {
    private boolean useAJAX = true;
    protected PageNode selectedNode_;
    protected Object selectedParent_;

    public UIComponent getViewModeUIComponent() {
        return null;
    }

    public void setUseAjax(boolean bl) {
        this.useAJAX = bl;
    }

    public boolean isUseAjax() {
        return this.useAJAX;
    }

    public List<PageNavigation> getNavigations() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ArrayList<PageNavigation> result = new ArrayList<PageNavigation>();
        for (PageNavigation nav : Util.getUIPortal().getNavigations()) {
            result.add(PageNavigationUtils.filter(nav, context.getRemoteUser()));
        }
        return result;
    }

    public PageNavigation getSelectedNavigation() {
        PageNavigation nav = Util.getUIPortal().getSelectedNavigation();
        if (nav != null) {
            return nav;
        }
        if (Util.getUIPortal().getNavigations().size() < 1) {
            return null;
        }
        return Util.getUIPortal().getNavigations().get(0);
    }

    public Object getSelectedParent() {
        return this.selectedParent_;
    }

    public PageNode getSelectedPageNode() {
        if (this.selectedNode_ != null) {
            return this.selectedNode_;
        }
        this.selectedNode_ = Util.getUIPortal().getSelectedNode();
        return this.selectedNode_;
    }

    public boolean isSelectedNode(PageNode node) {
        if (this.selectedNode_ != null && node.getUri().equals(this.selectedNode_.getUri())) {
            return true;
        }
        if (this.selectedParent_ == null || this.selectedParent_ instanceof PageNavigation) {
            return false;
        }
        PageNode pageNode = (PageNode)this.selectedParent_;
        return node.getUri().equals(pageNode.getUri());
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        if (uiPortal.getSelectedNode() != this.selectedNode_) {
            this.setSelectedPageNode(uiPortal.getSelectedNode());
        }
        super.processRender(context);
    }

    private void setSelectedPageNode(PageNode selectedNode) throws Exception {
        this.selectedNode_ = selectedNode;
        this.selectedParent_ = null;
        String seletctUri = selectedNode.getUri();
        int index = seletctUri.lastIndexOf("/");
        String parentUri = null;
        if (index > 0) {
            parentUri = seletctUri.substring(0, seletctUri.lastIndexOf("/"));
        }
        List<PageNavigation> pageNavs = this.getNavigations();
        for (PageNavigation pageNav : pageNavs) {
            if (PageNavigationUtils.searchPageNodeByUri(pageNav, selectedNode.getUri()) == null) continue;
            if (parentUri == null || parentUri.length() < 1) {
                this.selectedParent_ = pageNav;
                break;
            }
            this.selectedParent_ = PageNavigationUtils.searchPageNodeByUri(pageNav, parentUri);
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectNodeActionListener
    extends EventListener<UIPortalNavigation> {
        public void execute(Event<UIPortalNavigation> event) throws Exception {
            PageNode selectNode;
            UIPortalNavigation uiNavigation = (UIPortalNavigation)((Object)event.getSource());
            UIPortal uiPortal = Util.getUIPortal();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            int index = uri.lastIndexOf("::");
            String id = uri.substring(index + 2);
            PageNavigation selectNav = null;
            if (index <= 0) {
                selectNav = uiPortal.getSelectedNavigation();
            } else {
                String navId = uri.substring(0, index);
                selectNav = uiPortal.getPageNavigation(navId);
            }
            uiNavigation.selectedNode_ = selectNode = PageNavigationUtils.searchPageNodeByUri(selectNav, id);
            String parentUri = null;
            index = uri.lastIndexOf("/");
            if (index > 0) {
                parentUri = uri.substring(0, index);
            }
            uiNavigation.selectedParent_ = parentUri == null || parentUri.length() < 1 ? selectNav : PageNavigationUtils.searchPageNodeByUri(selectNav, parentUri);
            UIPageBody uiPageBody = (UIPageBody)uiPortal.findFirstComponentOfType(UIPageBody.class);
            if (uiPageBody != null && uiPageBody.getMaximizedUIComponent() != null) {
                UIPortlet currentPortlet = (UIPortlet)uiPageBody.getMaximizedUIComponent();
                currentPortlet.setCurrentWindowState(WindowState.NORMAL);
                uiPageBody.setMaximizedUIComponent(null);
            }
            PageNodeEvent<UIPortal> pnevent = new PageNodeEvent<UIPortal>(uiPortal, "ChangePageNode", null, uri);
            uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
        }
    }
}

