/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.UIWelcomeComponent;
import org.exoplatform.portal.webui.application.UIPortletOptions;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageEditBar;
import org.exoplatform.portal.webui.page.UIPagePreview;
import org.exoplatform.portal.webui.page.UIPageTemplateOptions;
import org.exoplatform.portal.webui.page.UIPageWizard;
import org.exoplatform.portal.webui.page.UIWizardPageCreationBar;
import org.exoplatform.portal.webui.page.UIWizardPageSelectLayoutForm;
import org.exoplatform.portal.webui.page.UIWizardPageSetInfo;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIExoStart;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/webui/core/UIWizard.gtmpl", events={@EventConfig(listeners={ViewStep1ActionListener.class}), @EventConfig(listeners={ViewStep2ActionListener.class}), @EventConfig(listeners={ViewStep3ActionListener.class}), @EventConfig(listeners={ViewStep4ActionListener.class}), @EventConfig(listeners={ViewStep5ActionListener.class}), @EventConfig(listeners={UIPageWizard.AbortActionListener.class})}), @ComponentConfig(id="ViewStep1", type=UIContainer.class, template="app:/groovy/portal/webui/page/UIWizardPageWelcome.gtmpl")})
public class UIPageCreationWizard
extends UIPageWizard {
    public UIPageCreationWizard() throws Exception {
        this.addChild(UIContainer.class, "ViewStep1", null);
        ((UIWizardPageSetInfo)this.addChild(UIWizardPageSetInfo.class, null, null)).setRendered(false);
        ((UIWizardPageSelectLayoutForm)this.addChild(UIWizardPageSelectLayoutForm.class, null, null)).setRendered(false);
        ((UIPagePreview)this.addChild(UIPagePreview.class, null, null)).setRendered(false);
        this.setNumberSteps(4);
        this.setShowWelcomeComponent(true);
    }

    private void saveData() throws Exception {
        UserPortalConfigService service = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        UIPagePreview uiPagePreview = (UIPagePreview)this.getChild(UIPagePreview.class);
        UIPage uiPage = (UIPage)uiPagePreview.getUIComponent();
        UIPortal uiPortal = Util.getUIPortal();
        if ("portal".equals(uiPage.getOwnerType())) {
            uiPage.setAccessPermissions(uiPortal.getAccessPermissions());
            uiPage.setEditPermission(uiPortal.getEditPermission());
        } else if ("group".equals(uiPage.getOwnerType())) {
            UserACL acl = (UserACL)this.getApplicationComponent(UserACL.class);
            uiPage.setAccessPermissions(new String[]{"*:/" + uiPage.getOwnerId()});
            uiPage.setEditPermission(acl.getMakableMT() + ":/" + uiPage.getOwnerId());
        }
        UIWizardPageSetInfo uiPageInfo = (UIWizardPageSetInfo)this.getChild(UIWizardPageSetInfo.class);
        UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageInfo.getChild(UIPageNodeSelector.class);
        PageNode selectedNode = uiNodeSelector.getSelectedPageNode();
        PageNavigation pageNav = uiNodeSelector.getSelectedNavigation();
        Page page = PortalDataMapper.toPageModel(uiPage);
        PageNode pageNode = uiPageInfo.getPageNode();
        pageNode.setPageReference(page.getPageId());
        if (selectedNode != null) {
            ArrayList<PageNode> children = selectedNode.getChildren();
            if (children == null) {
                children = new ArrayList<PageNode>();
            }
            children.add(pageNode);
            selectedNode.setChildren(children);
        } else {
            pageNav.addNode(pageNode);
        }
        pageNav.setModifier(((WebuiRequestContext)RequestContext.getCurrentInstance()).getRemoteUser());
        uiNodeSelector.selectPageNodeByUri(pageNode.getUri());
        service.create(page);
        service.update(pageNav);
        for (PageNavigation editNav : uiNodeSelector.getPageNavigations()) {
            this.setNavigation(uiPortal.getNavigations(), editNav);
        }
        String uri = pageNav.getId() + "::" + pageNode.getUri();
        PageNodeEvent<UIPortal> pnevent = new PageNodeEvent<UIPortal>(uiPortal, "ChangePageNode", null, uri);
        uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
    }

    private void setNavigation(List<PageNavigation> navs, PageNavigation nav) {
        for (int i = 0; i < navs.size(); ++i) {
            if (!navs.get(i).getId().equals(nav.getId())) continue;
            navs.set(i, nav);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep5ActionListener
    extends EventListener<UIPageCreationWizard> {
        public void execute(Event<UIPageCreationWizard> event) throws Exception {
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)((UIPageCreationWizard)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            uiPortalApp.setEditting(false);
            uiWizard.saveData();
            uiWizard.updateUIPortal(uiPortalApp, event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep4ActionListener
    extends EventListener<UIPageCreationWizard> {
        public void execute(Event<UIPageCreationWizard> event) throws Exception {
            boolean isDesktopPage;
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiWizard.getAncestorOfType(UIPortalApplication.class);
            PortalRequestContext context = Util.getPortalRequestContext();
            uiWizard.viewStep(4);
            if (uiWizard.getSelectedStep() < 4) {
                uiWizard.updateWizardComponent();
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.StepByStep", null));
                context.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            UIPageTemplateOptions uiPageTemplateOptions = (UIPageTemplateOptions)uiWizard.findFirstComponentOfType(UIPageTemplateOptions.class);
            UIWizardPageSetInfo uiPageInfo = (UIWizardPageSetInfo)uiWizard.getChild(UIWizardPageSetInfo.class);
            String ownerType = "user";
            String ownerId = context.getRemoteUser();
            UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageInfo.getChild(UIPageNodeSelector.class);
            PageNavigation pageNavi = uiNodeSelector.getSelectedNavigation();
            if (pageNavi != null) {
                ownerType = pageNavi.getOwnerType();
                ownerId = pageNavi.getOwnerId();
            }
            PageNode pageNode = uiPageInfo.getPageNode();
            Page page = uiPageTemplateOptions.getSelectedOption();
            if (page == null) {
                page = new Page();
                page.setCreator(context.getRemoteUser());
            }
            if (page.getOwnerType() == null || page.getOwnerType().trim().length() == 0) {
                page.setOwnerType(ownerType);
            }
            if (page.getOwnerId() == null || page.getOwnerId().trim().length() == 0) {
                page.setOwnerId(ownerId);
            }
            if (page.getName() == null || page.getName().trim().length() == 0 || page.getName().equals("UIPage")) {
                page.setName(pageNode.getName());
            }
            page.setModifiable(true);
            if (page.getTitle() == null || page.getTitle().trim().length() == 0) {
                page.setTitle(pageNode.getName());
            }
            if (isDesktopPage = "Desktop".equals(page.getFactoryId())) {
                page.setShowMaxWindow(Boolean.valueOf(true));
            }
            String pageId = page.getPageId();
            DataStorage service = (DataStorage)uiWizard.getApplicationComponent(DataStorage.class);
            Page existPage = service.getPage(pageId);
            if (existPage != null) {
                page.setName(page.getName() + String.valueOf(page.hashCode()));
                page.setPageId(pageId + String.valueOf(page.hashCode()));
            }
            UIPagePreview uiPagePreview = (UIPagePreview)uiWizard.getChild(UIPagePreview.class);
            UIPage uiPage = (UIPage)uiPagePreview.createUIComponent(context, UIPage.class, page.getFactoryId(), null);
            PortalDataMapper.toUIPage(uiPage, page);
            uiPagePreview.setUIComponent((UIComponent)uiPage);
            if (isDesktopPage) {
                uiWizard.saveData();
                uiWizard.updateUIPortal(uiPortalApp, event);
                return;
            }
            uiWizard.updateWizardComponent();
            Class[] childrenToRender = new Class[]{UIPageEditBar.class, UIPortletOptions.class};
            UIExoStart uiExoStart = (UIExoStart)uiPortalApp.findFirstComponentOfType(UIExoStart.class);
            uiExoStart.setUIControlWSWorkingComponent(UIWizardPageCreationBar.class);
            UIWizardPageCreationBar uiCreationBar = (UIWizardPageCreationBar)((Object)uiExoStart.getUIControlWSWorkingComponent());
            UIPageEditBar uiPageEditBar = (UIPageEditBar)uiCreationBar.getChild(UIPageEditBar.class);
            UIWizardPageCreationBar uiParent = (UIWizardPageCreationBar)uiPageEditBar.getParent();
            uiParent.setRenderedChildrenOfTypes(childrenToRender);
            uiPageEditBar.setUIPage(uiPage);
            uiPageTemplateOptions.setSelectedOption(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep3ActionListener
    extends EventListener<UIPageCreationWizard> {
        public void execute(Event<UIPageCreationWizard> event) throws Exception {
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiWizard.getAncestorOfType(UIPortalApplication.class);
            PortalRequestContext context = Util.getPortalRequestContext();
            uiWizard.viewStep(3);
            if (uiWizard.getSelectedStep() < 3) {
                uiWizard.updateWizardComponent();
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.StepByStep", null));
                context.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            UIWizardPageSetInfo uiPageSetInfo = (UIWizardPageSetInfo)uiWizard.getChild(UIWizardPageSetInfo.class);
            UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageSetInfo.getChild(UIPageNodeSelector.class);
            uiWizard.setDescriptionWizard(3);
            uiWizard.updateWizardComponent();
            PageNavigation navigation = uiNodeSelector.getSelectedNavigation();
            if (navigation == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.notSelectedPageNavigation", (Object[])new String[0]));
                context.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                uiWizard.viewStep(2);
                return;
            }
            PageNode pageNode = uiPageSetInfo.getPageNode();
            PageNode selectedPageNode = uiNodeSelector.getSelectedPageNode();
            List sibbling = new ArrayList();
            sibbling = selectedPageNode != null ? selectedPageNode.getChildren() : navigation.getNodes();
            if (sibbling != null) {
                for (PageNode ele : sibbling) {
                    if (!ele.getUri().equals(pageNode.getUri())) continue;
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.NameNotSame", null));
                    context.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                    uiWizard.viewStep(2);
                    return;
                }
            }
            String pageId = navigation.getOwnerType() + "::" + navigation.getOwnerId() + "::" + pageNode.getName();
            DataStorage storage = (DataStorage)uiWizard.getApplicationComponent(DataStorage.class);
            if (storage.getPage(pageId) != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.NameNotSame", null));
                context.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                uiWizard.viewStep(2);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep2ActionListener
    extends EventListener<UIPageWizard> {
        public void execute(Event<UIPageWizard> event) throws Exception {
            UIPageWizard uiWizard = (UIPageWizard)((Object)event.getSource());
            uiWizard.setDescriptionWizard(2);
            uiWizard.updateWizardComponent();
            uiWizard.viewStep(2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep1ActionListener
    extends EventListener<UIPageCreationWizard> {
        public void execute(Event<UIPageCreationWizard> event) throws Exception {
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiWizard.getAncestorOfType(UIPortalApplication.class);
            UIExoStart uiExoStart = (UIExoStart)uiPortalApp.findFirstComponentOfType(UIExoStart.class);
            uiExoStart.setUIControlWSWorkingComponent(UIWelcomeComponent.class);
            uiWizard.updateWizardComponent();
            uiWizard.viewStep(1);
        }
    }
}

