/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIItemSelector;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/portal/webui/portal/UILanguageSelector.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class})})
public class UILanguageSelector
extends UIContainer {
    private String name_ = "UIChangeLanguage";

    public UILanguageSelector() throws Exception {
        LocaleConfigService configService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        Locale currentLocale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        SelectItemOption localeItem = null;
        ArrayList<SelectItemOption> optionsList = new ArrayList<SelectItemOption>();
        Iterator i$ = configService.getLocalConfigs().iterator();
        while (i$.hasNext()) {
            LocaleConfig object;
            LocaleConfig localeConfig = object = (LocaleConfig)i$.next();
            Locale locale = localeConfig.getLocale();
            String displayName = locale.getDisplayLanguage();
            String lang = locale.getLanguage();
            String localedName = locale.getDisplayName(locale);
            if (localedName == null || localedName.length() == 0) {
                localedName = "???";
            }
            localeItem = locale.getDisplayName().equalsIgnoreCase(currentLocale.getDisplayName()) ? new SelectItemOption(displayName, (Object)lang, localedName, "", true) : new SelectItemOption(displayName, (Object)lang, localedName, "");
            optionsList.add(localeItem);
        }
        Collections.sort(optionsList, new LanguagesComparator());
        ArrayList<SelectItemCategory> contientsCategories = new ArrayList<SelectItemCategory>();
        SelectItemCategory category = new SelectItemCategory("Languages");
        category.setSelectItemOptions(optionsList);
        contientsCategories.add(category);
        UIItemSelector selector = new UIItemSelector("Language");
        selector.setItemCategories(contientsCategories);
        selector.setRendered(true);
        this.addChild((UIComponent)selector);
    }

    public String getName() {
        return this.name_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UILanguageSelector> {
        public void execute(Event<UILanguageSelector> event) throws Exception {
            String language = event.getRequestContext().getRequestParameter("language");
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            uiMaskWS.setUIComponent(null);
            Util.getPortalRequestContext().setFullRender(false);
            if (language == null || language.trim().length() < 1) {
                return;
            }
            LocaleConfigService localeConfigService = (LocaleConfigService)((UILanguageSelector)((Object)event.getSource())).getApplicationComponent(LocaleConfigService.class);
            LocaleConfig localeConfig = localeConfigService.getLocaleConfig(language);
            if (localeConfig == null) {
                localeConfig = localeConfigService.getDefaultLocaleConfig();
            }
            uiApp.setLocale(localeConfig.getLocale());
            UIPortal uiPortal = (UIPortal)uiApp.findFirstComponentOfType(UIPortal.class);
            uiPortal.setLocale(localeConfig.getLanguage());
            uiPortal.refreshNavigation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LanguagesComparator
    implements Comparator<SelectItemOption> {
        private LanguagesComparator() {
        }

        @Override
        public int compare(SelectItemOption item0, SelectItemOption item1) {
            return item0.getLabel().compareToIgnoreCase(item1.getLabel());
        }
    }
}

