/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.application.UIWidgets;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPageActionListener;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortalActionListener;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.portal.UIPortalLifecycle;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIPortalLifecycle.class, template="system:/groovy/portal/webui/portal/UIPortal.gtmpl", events={@EventConfig(listeners={UIPageActionListener.ChangePageNodeActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.MoveChildActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.RemoveJSApplicationToDesktopActionListener.class}), @EventConfig(listeners={UIPortalActionListener.ChangeWindowStateActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.ShowLoginFormActionListener.class}), @EventConfig(listeners={UIWidgets.ChangeOptionActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.ChangeLanguageActionListener.class})})
public class UIPortal
extends UIContainer {
    private String owner;
    private String locale;
    private String[] accessPermissions;
    private String editPermission;
    private String skin;
    private List<PageNavigation> navigations;
    private List<PageNode> selectedPaths_;
    private PageNode selectedNode_;
    private PageNavigation selectedNavigation_;
    private Map<String, String[]> publicParameters_ = new HashMap<String, String[]>();
    private UIComponent maximizedUIComponent;

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String s) {
        this.owner = s;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String s) {
        this.locale = s;
    }

    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    public void setAccessPermissions(String[] accessGroups) {
        this.accessPermissions = accessGroups;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String s) {
        this.skin = s;
    }

    public Map<String, String[]> getPublicParameters() {
        return this.publicParameters_;
    }

    public void setPublicParameters(Map<String, String[]> publicParams) {
        this.publicParameters_ = publicParams;
    }

    public List<PageNavigation> getNavigations() {
        return this.navigations;
    }

    public void setNavigation(List<PageNavigation> navs) throws Exception {
        this.navigations = navs;
        this.selectedPaths_ = new ArrayList<PageNode>();
        if (this.navigations == null || this.navigations.size() < 1) {
            return;
        }
        PageNavigation pNav = this.navigations.get(0);
        if (pNav.getNodes() == null || pNav.getNodes().size() < 1) {
            return;
        }
        this.selectedNode_ = (PageNode)pNav.getNodes().get(0);
        this.selectedPaths_.add(this.selectedNode_);
        UIPageBody uiPageBody = (UIPageBody)this.findFirstComponentOfType(UIPageBody.class);
        if (uiPageBody == null) {
            return;
        }
        uiPageBody.setPageBody(this.selectedNode_, this);
        this.refreshNavigation();
    }

    public void setSelectedNode(PageNode node) {
        this.selectedNode_ = node;
    }

    public PageNode getSelectedNode() {
        if (this.selectedNode_ != null) {
            return this.selectedNode_;
        }
        if (this.getSelectedNavigation() == null || this.selectedNavigation_.getNodes() == null || this.selectedNavigation_.getNodes().size() < 1) {
            return null;
        }
        this.selectedNode_ = (PageNode)this.selectedNavigation_.getNodes().get(0);
        return this.selectedNode_;
    }

    public List<PageNode> getSelectedPaths() {
        return this.selectedPaths_;
    }

    public void setSelectedPaths(List<PageNode> nodes) {
        this.selectedPaths_ = nodes;
    }

    public PageNavigation getSelectedNavigation() {
        if (this.selectedNavigation_ != null) {
            return this.selectedNavigation_;
        }
        if (this.getNavigations().size() < 1) {
            return null;
        }
        this.setSelectedNavigation(this.getNavigations().get(0));
        return this.getNavigations().get(0);
    }

    public PageNavigation getPageNavigation(String id) {
        for (PageNavigation nav : this.navigations) {
            if (!nav.getId().equals(id)) continue;
            return nav;
        }
        return null;
    }

    public void setSelectedNavigation(PageNavigation selectedNavigation) {
        this.selectedNavigation_ = selectedNavigation;
    }

    public UIComponent getMaximizedUIComponent() {
        return this.maximizedUIComponent;
    }

    public void setMaximizedUIComponent(UIComponent maximizedReferenceComponent) {
        this.maximizedUIComponent = maximizedReferenceComponent;
    }

    public void refreshNavigation() {
        LocaleConfig localeConfig = ((LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class)).getLocaleConfig(this.locale);
        for (PageNavigation nav : this.navigations) {
            if (nav.getOwnerType().equals("user")) continue;
            ResourceBundle res = localeConfig.getNavigationResourceBundle(nav.getOwnerType(), nav.getOwnerId());
            for (PageNode node : nav.getNodes()) {
                this.resolveLabel(res, node);
            }
        }
    }

    private void resolveLabel(ResourceBundle res, PageNode node) {
        node.setResolvedLabel(res);
        if (node.getChildren() == null) {
            return;
        }
        for (PageNode childNode : node.getChildren()) {
            this.resolveLabel(res, childNode);
        }
    }
}

