/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;

@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/portal/webui/portal/UIChangePortal.gtmpl", events={@EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class})}), @ComponentConfig(id="PortalSelector", type=UIGrid.class, template="app:/groovy/portal/webui/portal/UIPortalSelector.gtmpl")})
public class UIPortalSelector
extends UIContainer {
    public static String[] BEAN_FEILD = new String[]{"creator", "name", "skin"};
    public static String[] SELECT_ACTIONS = new String[]{"SelectPortal"};

    public UIPortalSelector() throws Exception {
        this.setName("UIChangePortal");
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, "PortalSelector", null);
        uiGrid.configure("name", BEAN_FEILD, SELECT_ACTIONS);
        uiGrid.getUIPageIterator().setId("ChangePortalPageInterator");
        this.addChild((UIComponent)uiGrid.getUIPageIterator());
        uiGrid.getUIPageIterator().setRendered(false);
        DataStorage dataService = (DataStorage)this.getApplicationComponent(DataStorage.class);
        String accessUser = Util.getPortalRequestContext().getRemoteUser();
        Query query = new Query(null, null, null, PortalConfig.class);
        PageList pageList = dataService.find(query);
        pageList.setPageSize(10);
        pageList = this.extractPermissedPortal(pageList, accessUser);
        uiGrid.getUIPageIterator().setPageList(pageList);
    }

    private PageList extractPermissedPortal(PageList pageList, String accessUser) throws Exception {
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        for (int i = 1; i <= pageList.getAvailablePage(); ++i) {
            List list = pageList.getPage(i);
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                PortalConfig pConfig = (PortalConfig)itr.next();
                if (userACL.hasPermission(pConfig, accessUser)) continue;
                itr.remove();
            }
        }
        return new ObjectPageList(pageList.getAll(), 10);
    }
}

