/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.Iterator;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.skin.SkinService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIItemSelector;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/portal/webui/portal/UISkinSelector.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class})})
public class UISkinSelector
extends UIContainer {
    private String name_ = "UIChangeSkin";

    public UISkinSelector() throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        ArrayList<SelectItemCategory> itemCategories = new ArrayList<SelectItemCategory>();
        SkinService skinService = (SkinService)uiPortal.getApplicationComponent(SkinService.class);
        Iterator<String> skinIterator = skinService.getAvailableSkins();
        while (skinIterator.hasNext()) {
            String skin = skinIterator.next();
            SelectItemCategory skinCategory = new SelectItemCategory(skin, false);
            skinCategory.addSelectItemOption(new SelectItemOption(skin, (Object)skin, skin));
            itemCategories.add(skinCategory);
        }
        ((SelectItemCategory)itemCategories.get(0)).setSelected(true);
        UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
        String currentSkin = uiPortalApp.getSkin();
        if (currentSkin == null) {
            currentSkin = "Default";
        }
        for (SelectItemCategory ele : itemCategories) {
            if (ele.getName().equals(currentSkin)) {
                ele.setSelected(true);
                continue;
            }
            ele.setSelected(false);
        }
        UIItemSelector selector = new UIItemSelector("Skin");
        selector.setItemCategories(itemCategories);
        selector.setRendered(true);
        this.addChild((UIComponent)selector);
    }

    public String url(String name) throws Exception {
        return super.url(name);
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISkinSelector> {
        public void execute(Event<UISkinSelector> event) throws Exception {
            String skin = event.getRequestContext().getRequestParameter("skin");
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            uiMaskWS.setUIComponent(null);
            Util.getPortalRequestContext().setFullRender(false);
            if (skin == null || skin.trim().length() < 1) {
                return;
            }
            uiApp.setSkin(skin);
        }
    }
}

