/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.util;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.Widgets;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.application.UIWidget;
import org.exoplatform.portal.webui.application.UIWidgets;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalDataMapper {
    public static final <T> T buildChild(UIComponent uiComponent) {
        PageBody model = null;
        if (uiComponent instanceof UIPageBody) {
            model = PortalDataMapper.toPageBodyModel((UIPageBody)uiComponent);
        } else if (uiComponent instanceof UIWidget) {
            model = PortalDataMapper.toWidget((UIWidget)uiComponent);
        } else if (uiComponent instanceof UIPortlet) {
            model = PortalDataMapper.toPortletModel((UIPortlet)uiComponent);
        } else if (uiComponent instanceof UIContainer) {
            model = PortalDataMapper.toContainer((UIContainer)uiComponent);
        }
        return (T)model;
    }

    public static final Application toWidget(UIWidget uiWidget) {
        Application model = new Application();
        model.setApplicationType("eXoWidget");
        model.setInstanceId(uiWidget.getApplicationInstanceId());
        model.setId(uiWidget.getId());
        model.setProperties(uiWidget.getProperties());
        return model;
    }

    private static void toContainer(Container model, UIContainer uiContainer) {
        model.setId(uiContainer.getId());
        model.setName(uiContainer.getName());
        model.setTitle(uiContainer.getTitle());
        model.setIcon(uiContainer.getIcon());
        model.setDescription(uiContainer.getDescription());
        model.setHeight(uiContainer.getHeight());
        model.setWidth(uiContainer.getWidth());
        model.setTemplate(uiContainer.getTemplate());
        model.setFactoryId(uiContainer.getFactoryId());
        List uiChildren = uiContainer.getChildren();
        if (uiChildren == null) {
            return;
        }
        ArrayList children = new ArrayList();
        for (UIComponent child : uiChildren) {
            Object component = PortalDataMapper.buildChild(child);
            if (component == null) continue;
            children.add(component);
        }
        model.setChildren(children);
    }

    public static final Application toPortletModel(UIPortlet uiPortlet) {
        Application model = new Application();
        model.setInstanceId(uiPortlet.getWindowId().toString());
        model.setApplicationType(uiPortlet.getFactoryId());
        model.setTitle(uiPortlet.getTitle());
        model.setWidth(uiPortlet.getWidth());
        model.setHeight(uiPortlet.getHeight());
        model.setDescription(uiPortlet.getDescription());
        model.setShowInfoBar(Boolean.valueOf(uiPortlet.getShowInfoBar()));
        model.setShowApplicationState(Boolean.valueOf(uiPortlet.getShowWindowState()));
        model.setShowApplicationMode(Boolean.valueOf(uiPortlet.getShowPortletMode()));
        model.setDescription(uiPortlet.getDescription());
        model.setIcon(uiPortlet.getIcon());
        model.setProperties(uiPortlet.getProperties());
        model.setTheme(uiPortlet.getTheme());
        return model;
    }

    public static final Container toContainer(UIContainer uiContainer) {
        Container model = new Container();
        PortalDataMapper.toContainer(model, uiContainer);
        return model;
    }

    public static final Page toPageModel(UIPage uiPage) {
        Page model = new Page();
        PortalDataMapper.toContainer((Container)model, uiPage);
        model.setCreator(uiPage.getCreator());
        model.setModifier(uiPage.getModifier());
        model.setOwnerId(uiPage.getOwnerId());
        model.setOwnerType(uiPage.getOwnerType());
        model.setIcon(uiPage.getIcon());
        model.setPageId(uiPage.getPageId());
        model.setAccessPermissions(uiPage.getAccessPermissions());
        model.setEditPermission(uiPage.getEditPermission());
        model.setFactoryId(uiPage.getFactoryId());
        model.setShowMaxWindow(Boolean.valueOf(uiPage.isShowMaxWindow()));
        model.setModifiable(uiPage.isModifiable());
        return model;
    }

    public static final PortalConfig toPortal(UIPortal uiPortal) {
        PortalConfig model = new PortalConfig();
        model.setName(uiPortal.getName());
        model.setCreator(uiPortal.getCreator());
        model.setModifier(uiPortal.getModifier());
        model.setFactoryId(uiPortal.getFactoryId());
        model.setAccessPermissions(uiPortal.getAccessPermissions());
        model.setEditPermission(uiPortal.getEditPermission());
        model.setLocale(uiPortal.getLocale());
        model.setSkin(uiPortal.getSkin());
        model.setTitle(uiPortal.getTitle());
        model.setModifiable(uiPortal.isModifiable());
        List children = uiPortal.getChildren();
        if (children == null) {
            return model;
        }
        ArrayList newChildren = new ArrayList();
        for (UIComponent child : children) {
            Object component = PortalDataMapper.buildChild(child);
            if (component == null) continue;
            newChildren.add(component);
        }
        model.getPortalLayout().setChildren(newChildren);
        return model;
    }

    public static final PageBody toPageBodyModel(UIPageBody uiPageBody) {
        return new PageBody();
    }

    public static final Widgets toWidgets(UIWidgets uiWidgets) throws Exception {
        Widgets model = new Widgets();
        model.setAccessPermissions(uiWidgets.getAccessPermissions());
        model.setEditPermission(uiWidgets.getEditPermission());
        model.setOwnerType(uiWidgets.getOwnerType());
        model.setOwnerId(uiWidgets.getOwnerId());
        List uiChildren = uiWidgets.getChildren();
        if (uiChildren == null) {
            return model;
        }
        ArrayList<Container> modelChildren = new ArrayList<Container>();
        for (UIComponent uiChild : uiChildren) {
            Container container = PortalDataMapper.toContainer((UIContainer)uiChild);
            modelChildren.add(container);
        }
        model.setChildren(modelChildren);
        return model;
    }

    public static void toUIWidget(UIWidget uiWidget, Application model) throws Exception {
        uiWidget.setApplicationInstanceId(model.getInstanceId());
        uiWidget.setId(model.getInstanceId());
        uiWidget.setProperties(model.getProperties());
    }

    public static void toUIPortlet(UIPortlet uiPortlet, Application model) throws Exception {
        uiPortlet.setWidth(model.getWidth());
        uiPortlet.setHeight(model.getHeight());
        uiPortlet.setWindowId(model.getInstanceId());
        uiPortlet.setTitle(model.getTitle());
        uiPortlet.setIcon(model.getIcon());
        uiPortlet.setDescription(model.getDescription());
        uiPortlet.setFactoryId(model.getApplicationType());
        uiPortlet.setShowInfoBar(model.getShowInfoBar());
        uiPortlet.setShowWindowState(model.getShowApplicationState());
        uiPortlet.setShowPortletMode(model.getShowApplicationMode());
        uiPortlet.setProperties(model.getProperties());
        uiPortlet.setTheme(model.getTheme());
        PortletContainerService portletContainer = (PortletContainerService)uiPortlet.getApplicationComponent(PortletContainerService.class);
        ExoWindowID windowId = uiPortlet.getExoWindowID();
        String portletId = windowId.getPortletApplicationName() + "/" + windowId.getPortletName();
        PortletData portletData = (PortletData)portletContainer.getAllPortletMetaData().get(portletId);
        if (portletData == null) {
            return;
        }
        List supportsList = portletData.getSupports();
        ArrayList<String> supportModes = new ArrayList<String>();
        for (int i = 0; i < supportsList.size(); ++i) {
            Supports supports = (Supports)supportsList.get(i);
            String mimeType = supports.getMimeType();
            if (!"text/html".equals(mimeType)) continue;
            List modes = supports.getPortletMode();
            for (int j = 0; j < modes.size(); ++j) {
                String mode = (String)modes.get(j);
                if ("config".equals(mode = mode.toLowerCase())) {
                    supportModes.add(mode);
                    continue;
                }
                supportModes.add(mode);
            }
            break;
        }
        if (supportModes.size() > 1) {
            supportModes.remove("view");
        }
        uiPortlet.setSupportModes(supportModes);
    }

    public static void toUIContainer(UIContainer uiContainer, Container model) throws Exception {
        uiContainer.setId(model.getId());
        uiContainer.setWidth(model.getWidth());
        uiContainer.setHeight(model.getHeight());
        uiContainer.setTitle(model.getTitle());
        uiContainer.setIcon(model.getIcon());
        uiContainer.setDescription(model.getDescription());
        uiContainer.setFactoryId(model.getFactoryId());
        uiContainer.setName(model.getName());
        uiContainer.setTemplate(model.getTemplate());
        ArrayList children = model.getChildren();
        if (children == null) {
            return;
        }
        for (Object child : children) {
            Object uiComp = PortalDataMapper.buildChild(uiContainer, child);
            if (uiComp == null) continue;
            uiContainer.addChild((UIComponent)uiComp);
        }
    }

    public static void toUIPage(UIPage uiPage, Page model) throws Exception {
        PortalDataMapper.toUIContainer(uiPage, (Container)model);
        uiPage.setCreator(model.getCreator());
        uiPage.setModifier(model.getModifier());
        uiPage.setOwnerId(model.getOwnerId());
        uiPage.setOwnerType(model.getOwnerType());
        uiPage.setIcon(model.getIcon());
        uiPage.setAccessPermissions(model.getAccessPermissions());
        uiPage.setEditPermission(model.getEditPermission());
        uiPage.setFactoryId(model.getFactoryId());
        uiPage.setPageId(model.getPageId());
        uiPage.setShowMaxWindow(model.isShowMaxWindow());
        uiPage.setModifiable(model.isModifiable());
        ArrayList portlets = new ArrayList();
        uiPage.findComponentOfType(portlets, UIPortlet.class);
        for (UIPortlet portlet : portlets) {
            portlet.setPortletInPortal(false);
        }
    }

    public static void toUIPortal(UIPortal uiPortal, UserPortalConfig userPortalConfig) throws Exception {
        PortalConfig model = userPortalConfig.getPortalConfig();
        uiPortal.setId("UIPortal");
        uiPortal.setCreator(model.getCreator());
        uiPortal.setModifier(model.getModifier());
        uiPortal.setName(model.getName());
        uiPortal.setFactoryId(model.getFactoryId());
        uiPortal.setOwner(model.getName());
        uiPortal.setTitle(model.getTitle());
        uiPortal.setModifiable(model.isModifiable());
        uiPortal.setLocale(model.getLocale());
        uiPortal.setSkin(model.getSkin());
        uiPortal.setAccessPermissions(model.getAccessPermissions());
        uiPortal.setEditPermission(model.getEditPermission());
        ArrayList children = model.getPortalLayout().getChildren();
        if (children != null) {
            for (Object child : children) {
                Object uiComp = PortalDataMapper.buildChild(uiPortal, child);
                if (uiComp == null) continue;
                uiPortal.addChild((UIComponent)uiComp);
            }
        }
        uiPortal.setNavigation(userPortalConfig.getNavigations());
    }

    public static void toUIWidgets(UIWidgets uiWidgets, Widgets model) throws Exception {
        uiWidgets.setId(model.getId());
        uiWidgets.setAccessPermissions(model.getAccessPermissions());
        uiWidgets.setEditPermission(model.getEditPermission());
        uiWidgets.setOwnerType(model.getOwnerType());
        uiWidgets.setOwnerId(model.getOwnerId());
        uiWidgets.getChildren().clear();
        ArrayList children = model.getChildren();
        if (children == null) {
            return;
        }
        PortalRequestContext context = Util.getPortalRequestContext();
        for (Container child : children) {
            UIContainer uiContainer = (UIContainer)uiWidgets.createUIComponent(context, UIContainer.class, "WidgetContainer", null);
            uiContainer.setRendered(false);
            PortalDataMapper.toUIContainer(uiContainer, child);
            uiWidgets.addChild((UIComponent)uiContainer);
        }
        uiWidgets.updateDropdownList();
    }

    private static <T extends UIComponent> T buildChild(UIPortalComponent uiParent, Object model) throws Exception {
        Object uiComponent = null;
        PortalRequestContext context = Util.getPortalRequestContext();
        if (model instanceof PageBody) {
            UIPageBody uiPageBody;
            uiComponent = uiPageBody = (UIPageBody)uiParent.createUIComponent(context, UIPageBody.class, null, null);
        } else if (model instanceof Application) {
            Application application = (Application)model;
            String factoryId = application.getApplicationType();
            if (factoryId == null || factoryId.equals("portlet")) {
                UIPortlet uiPortlet = (UIPortlet)uiParent.createUIComponent(context, UIPortlet.class, null, null);
                PortalDataMapper.toUIPortlet(uiPortlet, application);
                uiComponent = uiPortlet;
            } else if (factoryId.equals("eXoWidget")) {
                UIWidget uiWidget = (UIWidget)uiParent.createUIComponent(context, UIWidget.class, null, null);
                PortalDataMapper.toUIWidget(uiWidget, application);
                uiComponent = uiWidget;
            }
        } else if (model instanceof Container) {
            Container container = (Container)model;
            UIContainer uiContainer = (UIContainer)uiParent.createUIComponent(context, UIContainer.class, container.getFactoryId(), null);
            PortalDataMapper.toUIContainer(uiContainer, (Container)model);
            uiComponent = uiContainer;
        }
        return (T)uiComponent;
    }
}

