/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.service.orchestra;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.ow2.orchestra.console.service.orchestra.DeploymentException;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.util.Misc;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestraService
implements Startable {
    protected String jmxServiceUrl;
    protected String jmxObjectName;
    private boolean started = false;

    public void start() {
    }

    public void init() {
        if (!this.started) {
            this.started = true;
            InputStream orchestraPropsStream = this.getClass().getClassLoader().getResourceAsStream("orchestra.properties");
            if (orchestraPropsStream == null) {
                throw new RuntimeException("orchestra.properties not found in classpath." + Misc.LINE_SEPARATOR);
            }
            Properties orchestraProperties = new Properties();
            try {
                orchestraProperties.load(orchestraPropsStream);
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Exception occured while loading orchestra.properties", (Throwable)e);
            }
            this.jmxServiceUrl = orchestraProperties.getProperty("orchestra.jmx.serviceUrl");
            this.jmxObjectName = orchestraProperties.getProperty("orchestra.jmx.objectName");
        }
    }

    public void stop() {
    }

    public void deployProcess(InputStream is) throws IOException, DeploymentException {
        this.init();
        byte[] barFile = Misc.getAllContentFrom((InputStream)is);
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            remoteDeployer.deployBar(barFile);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while deploying barFile: ", e);
        }
    }

    public void undeployProcess(String pduuid) {
        this.init();
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            remoteDeployer.undeploy(new ProcessDefinitionUUID(pduuid));
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught while undeploying process : " + pduuid, (Throwable)e);
        }
    }

    public List<ProcessDefinition> getProcesses() {
        this.init();
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            List processDefinitionDataList = remoteDeployer.findProcessDefinitions(ProcessState.DEPLOYED);
            return processDefinitionDataList;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    public ProcessDefinition getProcess(String pduuid) {
        this.init();
        try {
            RemoteDeployerMBean mbean = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            ProcessDefinition processDef = mbean.getProcessDefinition(new ProcessDefinitionUUID(pduuid));
            return processDef;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Error while getting process definition " + pduuid, (Throwable)e);
        }
    }

    public Set<ProcessInstance> getInstances() throws DeploymentException {
        this.init();
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            return remoteDeployer.findProcessInstances();
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while getting process instances list", e);
        }
    }

    public Set<ProcessInstance> getInstances(ProcessDefinitionUUID pduuid) throws DeploymentException {
        this.init();
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            return remoteDeployer.findProcessInstances(pduuid);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while getting process instances list", e);
        }
    }
}

