/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.exoplatform.services.document.DCMetaData;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.util.PDFTextStripper;

public class PDFDocumentReader
extends BaseDocumentReader {
    protected static Log log = ExoLogger.getLogger((String)"platform.PDFDocumentReader");

    public String[] getMimeTypes() {
        return new String[]{"application/pdf"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws Exception {
        PDDocument pdDocument = PDDocument.load((InputStream)is);
        StringWriter sw = new StringWriter();
        try {
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setStartPage(1);
            stripper.setEndPage(Integer.MAX_VALUE);
            stripper.writeText(pdDocument, (Writer)sw);
        }
        finally {
            if (pdDocument != null) {
                pdDocument.close();
            }
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(InputStream is) throws Exception {
        PDDocument pdDocument = PDDocument.load((InputStream)is);
        PDDocumentInformation docInfo = pdDocument.getDocumentInformation();
        Properties props = new Properties();
        try {
            try {
                if (docInfo.getAuthor() != null) {
                    props.put(DCMetaData.CONTRIBUTOR, docInfo.getAuthor());
                }
            }
            catch (Exception e) {
                log.warn((Object)("getAuthor failed: " + e));
            }
            try {
                if (docInfo.getCreationDate() != null) {
                    props.put(DCMetaData.DATE, docInfo.getCreationDate());
                }
            }
            catch (Exception e) {
                log.warn((Object)("getCreationDate failed: " + e));
            }
            try {
                if (docInfo.getCreator() != null) {
                    props.put(DCMetaData.CREATOR, docInfo.getCreator());
                }
            }
            catch (Exception e) {
                log.warn((Object)("getCreator failed: " + e));
            }
            try {
                if (docInfo.getKeywords() != null) {
                    props.put(DCMetaData.SUBJECT, docInfo.getKeywords());
                }
            }
            catch (Exception e) {
                log.warn((Object)("getKeywords failed: " + e));
            }
            try {
                if (docInfo.getModificationDate() != null) {
                    props.put(DCMetaData.DATE, docInfo.getModificationDate());
                }
            }
            catch (Exception e) {
                log.warn((Object)("getModificationDate failed: " + e));
            }
            try {
                if (docInfo.getProducer() != null) {
                    props.put(DCMetaData.PUBLISHER, docInfo.getProducer());
                }
            }
            catch (Exception e) {
                log.warn((Object)("getProducer failed: " + e));
            }
            try {
                if (docInfo.getSubject() != null) {
                    props.put(DCMetaData.DESCRIPTION, docInfo.getSubject());
                }
            }
            catch (Exception e) {
                log.warn((Object)("getSubject failed: " + e));
            }
            try {
                if (docInfo.getTitle() != null) {
                    props.put(DCMetaData.TITLE, docInfo.getTitle());
                }
            }
            catch (Exception e) {
                log.warn((Object)("getTitle failed: " + e));
            }
        }
        finally {
            if (pdDocument != null) {
                pdDocument.close();
            }
        }
        return props;
    }
}

