/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputContainer;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormLifecycle
extends Lifecycle {
    @Override
    public void processDecode(UIComponent uicomponent, WebuiRequestContext context) throws Exception {
        UIForm uiForm = (UIForm)uicomponent;
        uiForm.setSubmitAction(null);
        this.processNormalRequest(uiForm, context);
        List<UIComponent> children = uiForm.getChildren();
        for (UIComponent uiChild : children) {
            uiChild.processDecode(context);
        }
        String action = uiForm.getSubmitAction();
        String subComponentId = context.getRequestParameter("subComponentId");
        if (subComponentId == null || subComponentId.trim().length() < 1) {
            Event<UIComponent> event = uiForm.createEvent(action, Event.Phase.DECODE, context);
            if (event != null) {
                event.broadcast();
            }
            return;
        }
        Object uiSubComponent = uiForm.findComponentById(subComponentId);
        Event<UIComponent> event = ((UIComponent)uiSubComponent).createEvent(action, Event.Phase.DECODE, context);
        if (event != null) {
            event.broadcast();
        }
    }

    @Override
    public void processAction(UIComponent uicomponent, WebuiRequestContext context) throws Exception {
        UIForm uiForm = (UIForm)uicomponent;
        String action = context.getRequestParameter("formOp");
        if (action == null) {
            action = uiForm.getSubmitAction();
        }
        if (action == null) {
            return;
        }
        Event<UIComponent> event = uicomponent.createEvent(action, Event.Phase.PROCESS, context);
        if (event == null) {
            event = ((UIComponent)uicomponent.getParent()).createEvent(action, Event.Phase.PROCESS, context);
        }
        if (event == null) {
            return;
        }
        UIApplication uiApp = uiForm.getAncestorOfType(UIApplication.class);
        List<UIComponent> children = uiForm.getChildren();
        this.validateChildren(children, uiApp, context);
        if (context.getProcessRender()) {
            context.addUIComponentToUpdateByAjax(uiApp.getUIPopupMessages());
            return;
        }
        event.broadcast();
    }

    private void processNormalRequest(UIForm uiForm, WebuiRequestContext context) throws Exception {
        ArrayList inputs = new ArrayList();
        uiForm.findComponentOfType(inputs, UIFormInputBase.class);
        uiForm.setSubmitAction(context.getRequestParameter("formOp"));
        for (UIFormInputBase input : inputs) {
            if (!this.checkVisible(input)) continue;
            String inputValue = context.getRequestParameter(input.getId());
            if (inputValue == null || inputValue.trim().length() == 0) {
                inputValue = context.getRequestParameter(input.getName());
            }
            input.decode(inputValue, context);
        }
    }

    public boolean checkVisible(UIFormInputBase input) {
        return input.isRendered() && input.isEditable() && input.isEnable();
    }

    private void validateChildren(List<UIComponent> children, UIApplication uiApp, WebuiRequestContext context) {
        for (UIComponent uiChild : children) {
            List<Validator> validators;
            UIContainer uiInput;
            if (uiChild instanceof UIFormInputBase) {
                uiInput = (UIFormInputBase)uiChild;
                if (!this.checkVisible((UIFormInputBase)uiInput) || (validators = ((UIFormInputBase)uiInput).getValidators()) == null) continue;
                try {
                    for (Validator validator : validators) {
                        validator.validate((UIFormInput)((Object)uiInput));
                    }
                    continue;
                }
                catch (MessageException ex) {
                    uiApp.addMessage(ex.getDetailMessage());
                    context.setProcessRender(true);
                    continue;
                }
                catch (Exception ex) {
                    uiApp.addMessage(new ApplicationMessage(ex.getMessage(), null));
                    context.setProcessRender(true);
                    continue;
                }
            }
            if (uiChild instanceof UIFormInputSet) {
                UIFormInputSet uiInputSet = (UIFormInputSet)uiChild;
                this.validateChildren(uiInputSet.getChildren(), uiApp, context);
                continue;
            }
            if (!(uiChild instanceof UIFormInputContainer) || (validators = ((UIFormInputContainer)(uiInput = (UIFormInputContainer)uiChild)).getValidators()) == null) continue;
            try {
                for (Validator validator : validators) {
                    validator.validate((UIFormInput)((Object)uiInput));
                }
            }
            catch (MessageException ex) {
                uiApp.addMessage(ex.getDetailMessage());
                context.setProcessRender(true);
            }
            catch (Exception ex) {
                uiApp.addMessage(new ApplicationMessage(ex.getMessage(), null));
                context.setProcessRender(true);
            }
        }
    }
}

