/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.lifecycle;

import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.javascript.JavaScriptEngine;
import org.exoplatform.javascript.TemplateContext;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIContainer;

public class WebuiTemplateContext
extends TemplateContext {
    private UIComponent uicomponent_;
    private WebuiRequestContext rcontext_;

    public WebuiTemplateContext(JavaScriptEngine engine, ResourceResolver resolver, UIComponent uicomponent, WebuiRequestContext context) throws Exception {
        super(engine, resolver, context.getWriter());
        this.uicomponent_ = uicomponent;
        this.rcontext_ = context;
    }

    public UIComponent getUIComponent() {
        return this.uicomponent_;
    }

    public WebuiRequestContext getRequestContext() {
        return this.rcontext_;
    }

    public String appRes(String mesgKey) throws Exception {
        String value;
        try {
            ResourceBundle res = this.rcontext_.getApplicationResourceBundle();
            value = res.getString(mesgKey);
        }
        catch (MissingResourceException ex) {
            System.err.println("\nkey : " + mesgKey + "\n");
            value = mesgKey.substring(mesgKey.lastIndexOf(46) + 1);
        }
        return value;
    }

    public void renderChildren() throws Exception {
        if (this.uicomponent_ instanceof UIComponentDecorator) {
            UIComponentDecorator uiComponentDecorator = (UIComponentDecorator)this.uicomponent_;
            if (uiComponentDecorator.getUIComponent() == null) {
                return;
            }
            uiComponentDecorator.getUIComponent().processRender(this.rcontext_);
            return;
        }
        UIContainer uicontainer = (UIContainer)this.uicomponent_;
        List<UIComponent> children = uicontainer.getChildren();
        for (UIComponent child : children) {
            if (!child.isRendered()) continue;
            child.processRender(this.rcontext_);
        }
    }

    public void renderChild(String id) throws Exception {
        if (!(this.uicomponent_ instanceof UIContainer)) {
            return;
        }
        UIContainer uicontainer = (UIContainer)this.uicomponent_;
        Object uiChild = uicontainer.getChildById(id);
        ((UIComponent)uiChild).processRender(this.rcontext_);
    }

    public void renderUIComponent(UIComponent uicomponent) throws Exception {
        uicomponent.processRender(this.rcontext_);
    }

    public void renderChild(int index) throws Exception {
        if (!(this.uicomponent_ instanceof UIContainer)) {
            return;
        }
        UIContainer uicontainer = (UIContainer)this.uicomponent_;
        Object uiChild = uicontainer.getChild(index);
        ((UIComponent)uiChild).processRender(this.rcontext_);
    }
}

