/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class VariableExpression
extends Expression
implements Variable {
    public static final VariableExpression THIS_EXPRESSION = new VariableExpression("this", ClassHelper.DYNAMIC_TYPE);
    public static final VariableExpression SUPER_EXPRESSION = new VariableExpression("super", ClassHelper.DYNAMIC_TYPE);
    private String variable;
    private boolean inStaticContext;
    private boolean isDynamicTyped = false;
    private Variable accessedVariable;
    boolean closureShare = false;

    public Variable getAccessedVariable() {
        return this.accessedVariable;
    }

    public void setAccessedVariable(Variable origin) {
        this.accessedVariable = origin;
    }

    public VariableExpression(String variable, ClassNode type) {
        this.variable = variable;
        this.setType(ClassHelper.getWrapper(type));
    }

    public VariableExpression(String variable) {
        this(variable, ClassHelper.DYNAMIC_TYPE);
    }

    public VariableExpression(Variable variable) {
        this(variable.getName(), variable.getType());
        this.setAccessedVariable(variable);
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitVariableExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    public String getText() {
        return this.variable;
    }

    public String getName() {
        return this.variable;
    }

    public String toString() {
        return super.toString() + "[variable: " + this.variable + (this.isDynamicTyped() ? "" : " type: " + this.getType()) + "]";
    }

    public Expression getInitialExpression() {
        return null;
    }

    public boolean hasInitialExpression() {
        return false;
    }

    public boolean isInStaticContext() {
        if (this.accessedVariable != null && this.accessedVariable != this) {
            return this.accessedVariable.isInStaticContext();
        }
        return this.inStaticContext;
    }

    public void setInStaticContext(boolean inStaticContext) {
        this.inStaticContext = inStaticContext;
    }

    public void setType(ClassNode cn) {
        super.setType(cn);
        this.isDynamicTyped |= ClassHelper.DYNAMIC_TYPE == cn;
    }

    public boolean isDynamicTyped() {
        return this.isDynamicTyped;
    }

    public boolean isClosureSharedVariable() {
        if (this.accessedVariable != null && this.accessedVariable != this) {
            return this.accessedVariable.isClosureSharedVariable();
        }
        return this.closureShare;
    }

    public void setClosureSharedVariable(boolean inClosure) {
        this.closureShare = inClosure;
    }

    public ClassNode getType() {
        if (this.accessedVariable != null && this.accessedVariable != this) {
            return this.accessedVariable.getType();
        }
        return super.getType();
    }
}

