/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.jcr;

import org.exoplatform.services.resources.ResourceBundleData;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataMapper {
    static final String LOCALE = "locale";
    static final String EXO_REGISTRYENTRY_NT = "exo:registryEntry";
    static final String PRIMARY_TYPE = "jcr:primaryType";
    static final String TYPE = "exo:type";
    static final String ID = "exo:resourceId";
    static final String NAME = "exo:resourceName";
    static final String LANGUAGE = "exo:resourceLanguage";
    static final String COUNTRY = "exo:resourceCountry";
    static final String VARIANT = "exo:resourceVariant";
    static final String RESOUCE_TYPE = "exo:resourceType";
    static final String DATA = "data";

    public void map(Document doc, ResourceBundleData resource) throws Exception {
        Element root = doc.getDocumentElement();
        this.prepareXmlNamespace(root);
        root.setAttribute(PRIMARY_TYPE, EXO_REGISTRYENTRY_NT);
        root.setAttribute(TYPE, LOCALE);
        root.setAttribute(ID, resource.getId());
        root.setAttribute(NAME, resource.getName());
        root.setAttribute(LANGUAGE, resource.getLanguage());
        root.setAttribute(COUNTRY, resource.getCountry());
        root.setAttribute(VARIANT, resource.getVariant());
        root.setAttribute(RESOUCE_TYPE, resource.getResourceType());
        this.setDataValue(doc, DATA, resource.getData());
    }

    public ResourceBundleData toResourceBundleData(Document doc) throws Exception {
        ResourceBundleData resource = new ResourceBundleData();
        Element root = doc.getDocumentElement();
        resource.setId(root.getAttribute(ID));
        resource.setName(root.getAttribute(NAME));
        resource.setLanguage(root.getAttribute(LANGUAGE));
        resource.setCountry(root.getAttribute(COUNTRY));
        resource.setVariant(root.getAttribute(VARIANT));
        resource.setResourceType(root.getAttribute(RESOUCE_TYPE));
        resource.setData(this.getDataValue(doc, DATA));
        return resource;
    }

    private void prepareXmlNamespace(Element element) {
        this.setXmlNameSpace(element, "xmlns:exo", "http://www.exoplatform.com/jcr/exo/1.0");
        this.setXmlNameSpace(element, "xmlns:jcr", "http://www.jcp.org/jcr/1.0");
    }

    private void setXmlNameSpace(Element element, String key, String value) {
        String xmlns = element.getAttribute(key);
        if (xmlns == null || xmlns.trim().length() < 1) {
            element.setAttribute(key, value);
        }
    }

    private void setDataValue(Document doc, String name, String value) {
        Node child;
        Element dataElement = this.createDataElement(doc, name);
        while ((child = dataElement.getFirstChild()) != null) {
            dataElement.removeChild(child);
        }
        CDATASection data = doc.createCDATASection(value);
        dataElement.appendChild(data);
    }

    String getDataValue(Document doc, String name) {
        Element dataElement = this.createDataElement(doc, name);
        return dataElement.getFirstChild().getNodeValue();
    }

    private Element createDataElement(Document doc, String name) {
        Element ele = (Element)doc.getElementsByTagName(name).item(0);
        if (ele == null) {
            ele = doc.createElement(name);
            doc.getDocumentElement().appendChild(ele);
        }
        return ele;
    }
}

