/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.SlidePersistAtom;

public class SlideListWithText
extends RecordContainer {
    private Record[] _children;
    private byte[] _header = new byte[8];
    private static long _type = 4080L;
    private SlideAtomsSet[] slideAtomsSets;

    protected SlideListWithText(byte[] source, int start, int len) {
        int i;
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        Vector<SlideAtomsSet> sets = new Vector<SlideAtomsSet>();
        for (i = 0; i < this._children.length; ++i) {
            int endPos;
            if (!(this._children[i] instanceof SlidePersistAtom)) continue;
            for (endPos = i + 1; endPos < this._children.length && !(this._children[endPos] instanceof SlidePersistAtom); ++endPos) {
            }
            int clen = endPos - i - 1;
            if (clen == 0) continue;
            Record[] spaChildren = new Record[clen];
            System.arraycopy(this._children, i + 1, spaChildren, 0, clen);
            SlideAtomsSet set = new SlideAtomsSet((SlidePersistAtom)this._children[i], spaChildren);
            sets.add(set);
            i += clen;
        }
        this.slideAtomsSets = new SlideAtomsSet[sets.size()];
        for (i = 0; i < this.slideAtomsSets.length; ++i) {
            this.slideAtomsSets[i] = (SlideAtomsSet)sets.get(i);
        }
    }

    public SlideAtomsSet[] getSlideAtomsSets() {
        return this.slideAtomsSets;
    }

    public long getRecordType() {
        return _type;
    }

    public Record[] getChildRecords() {
        return this._children;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }

    public class SlideAtomsSet {
        private SlidePersistAtom slidePersistAtom;
        private Record[] slideRecords;

        public SlidePersistAtom getSlidePersistAtom() {
            return this.slidePersistAtom;
        }

        public Record[] getSlideRecords() {
            return this.slideRecords;
        }

        public SlideAtomsSet(SlidePersistAtom s, Record[] r) {
            this.slidePersistAtom = s;
            this.slideRecords = r;
        }
    }
}

