/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import javax.jcr.RepositoryException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.WorkspaceInitializer;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;

public class WorkspaceContainer
extends ExoContainer {
    protected static Log log = ExoLogger.getLogger((String)"jcr.WorkspaceContainer");
    private final String name;
    private final RepositoryContainer repositoryContainer;
    private final MBeanServer mbeanServer;

    public WorkspaceContainer(RepositoryContainer parent, WorkspaceEntry config) throws RepositoryException, RepositoryConfigurationException {
        super((ComponentAdapterFactory)new MX4JComponentAdapterFactory(), (PicoContainer)parent);
        this.repositoryContainer = parent;
        this.name = config.getName();
        this.mbeanServer = MBeanServerFactory.createMBeanServer("jcrws" + this.name + "at" + this.repositoryContainer.getName() + "mx");
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public SessionFactory getSessionFactory() {
        return (SessionFactory)this.getComponentInstanceOfType(SessionFactory.class);
    }

    public WorkspaceInitializer getWorkspaceInitializer() {
        return (WorkspaceInitializer)this.getComponentInstanceOfType(WorkspaceInitializer.class);
    }

    public void stop() {
        try {
            this.stopContainer();
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        super.stop();
    }
}

