/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import org.exoplatform.services.jcr.datamodel.QPath;

public class JCRPathMatcher {
    private QPath knownPath = null;
    private boolean forDescendants = false;
    private boolean forAncestors = false;

    public JCRPathMatcher(QPath knownPath, boolean forDescendants, boolean forAncestors) {
        this.knownPath = knownPath;
        this.forDescendants = forDescendants;
        this.forAncestors = forAncestors;
    }

    public boolean match(QPath path) {
        if (this.forDescendants && this.forAncestors && this.knownPath == null) {
            return true;
        }
        if (this.forDescendants && this.knownPath != null) {
            return path.isDescendantOf(this.knownPath, false);
        }
        if (this.forDescendants && this.knownPath != null) {
            return this.knownPath.isDescendantOf(path, false);
        }
        if (this.forDescendants && this.forAncestors && this.knownPath != null) {
            return path.isDescendantOf(this.knownPath, false) && this.knownPath.isDescendantOf(path, false);
        }
        return this.knownPath.equals(path);
    }
}

