/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.impl.core.NamespaceDataPersister;
import org.exoplatform.services.log.ExoLogger;

public class NamespaceRegistryImpl
implements NamespaceRegistry,
NamespaceAccessor {
    public static final Map<String, String> DEF_NAMESPACES = new HashMap<String, String>();
    public static final Map<String, String> DEF_PREFIXES = new HashMap<String, String>();
    private static final Set<String> PROTECTED_NAMESPACES = new HashSet<String>();
    protected static final Log log = ExoLogger.getLogger((String)"jcr.NamespaceRegistryImpl");
    private Map<String, String> namespaces;
    private NamespaceDataPersister persister;
    private Map<String, String> prefixes;

    public NamespaceRegistryImpl() {
        this.namespaces = DEF_NAMESPACES;
        this.prefixes = DEF_PREFIXES;
    }

    public NamespaceRegistryImpl(NamespaceDataPersister persister) {
        this.namespaces = new HashMap<String, String>(DEF_NAMESPACES);
        this.prefixes = new HashMap<String, String>(DEF_PREFIXES);
        this.persister = persister;
    }

    public String[] getAllNamespacePrefixes() {
        return this.getPrefixes();
    }

    public String getNamespacePrefixByURI(String uri) throws NamespaceException, RepositoryException {
        return this.getPrefix(uri);
    }

    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException {
        return this.getURI(prefix);
    }

    public String getPrefix(String uri) throws NamespaceException {
        String prefix = this.prefixes.get(uri);
        if (prefix != null) {
            return prefix;
        }
        throw new NamespaceException("Prefix for " + uri + " not found");
    }

    public String[] getPrefixes() {
        return this.namespaces.keySet().toArray(new String[this.namespaces.keySet().size()]);
    }

    public String getURI(String prefix) throws NamespaceException {
        String uri = this.namespaces.get(prefix);
        if (uri == null) {
            throw new NamespaceException("Unknown Prefix " + prefix);
        }
        return uri;
    }

    public String[] getURIs() {
        return this.namespaces.values().toArray(new String[this.namespaces.size()]);
    }

    public boolean isDefaultNamespace(String uri) {
        return DEF_PREFIXES.containsKey(uri);
    }

    public boolean isDefaultPrefix(String prefix) {
        return DEF_NAMESPACES.containsKey(prefix);
    }

    public boolean isPrefixMaped(String prefix) {
        return this.namespaces.containsKey(prefix);
    }

    public boolean isUriRegistered(String uri) {
        return this.prefixes.containsKey(uri);
    }

    public void loadFromStorage() throws RepositoryException {
        try {
            this.persister.loadNamespaces(this.namespaces, this.prefixes);
        }
        catch (PathNotFoundException e) {
            log.info((Object)("Namespaces storage (/jcr:system/exo:namespaces) is not accessible. Default namespaces only will be used. " + (Object)((Object)e)));
            return;
        }
    }

    public synchronized void registerNamespace(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.validateNamespace(prefix, uri);
        if (this.namespaces.containsKey(prefix) || this.prefixes.containsKey(uri)) {
            throw new NamespaceException("Re-registration is not supported as may cause integrity problems. (todo issue #46)");
        }
        this.persister.addNamespace(prefix, uri);
        this.persister.saveChanges();
        String newPrefix = new String(prefix);
        String newUri = new String(uri);
        this.namespaces.put(newPrefix, newUri);
        this.prefixes.put(newUri, newPrefix);
    }

    public void unregisterNamespace(String prefix) throws NamespaceException, RepositoryException {
        if (this.namespaces.get(prefix) == null) {
            throw new NamespaceException("Prefix " + prefix + " is not registered");
        }
        if (PROTECTED_NAMESPACES.contains(prefix)) {
            throw new NamespaceException("Prefix " + prefix + " is protected");
        }
        throw new NamespaceException("Unregistration is not supported as may cause integrity problems. (todo issue #46)");
    }

    public void validateNamespace(String prefix, String uri) throws NamespaceException, RepositoryException {
        if (prefix.indexOf(":") > 0) {
            throw new RepositoryException("Namespace prefix should not contain ':' " + prefix);
        }
        if (PROTECTED_NAMESPACES.contains(prefix)) {
            if (uri == null) {
                throw new NamespaceException("Can not remove built-in namespace");
            }
            throw new NamespaceException("Can not change built-in namespace");
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            throw new NamespaceException("Can not re-assign prefix that start with 'xml'");
        }
        if (uri == null) {
            throw new NamespaceException("Can not register NULL URI!");
        }
    }

    static {
        DEF_NAMESPACES.put("", "");
        DEF_NAMESPACES.put("jcr", "http://www.jcp.org/jcr/1.0");
        DEF_NAMESPACES.put("nt", "http://www.jcp.org/jcr/nt/1.0");
        DEF_NAMESPACES.put("mix", "http://www.jcp.org/jcr/mix/1.0");
        DEF_NAMESPACES.put("xml", "http://www.w3.org/XML/1998/namespace");
        DEF_NAMESPACES.put("sv", "http://www.jcp.org/jcr/sv/1.0");
        DEF_NAMESPACES.put("exo", "http://www.exoplatform.com/jcr/exo/1.0");
        DEF_NAMESPACES.put("xs", "http://www.w3.org/2001/XMLSchema");
        DEF_NAMESPACES.put("fn", "http://www.w3.org/2004/10/xpath-functions");
        DEF_PREFIXES.put("", "");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/1.0", "jcr");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/nt/1.0", "nt");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/mix/1.0", "mix");
        DEF_PREFIXES.put("http://www.w3.org/XML/1998/namespace", "mix");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/sv/1.0", "sv");
        DEF_PREFIXES.put("http://www.exoplatform.com/jcr/exo/1.0", "exo");
        DEF_PREFIXES.put("http://www.w3.org/2001/XMLSchema", "xs");
        DEF_PREFIXES.put("http://www.w3.org/2001/XMLSchema", "fn");
        PROTECTED_NAMESPACES.add("jcr");
        PROTECTED_NAMESPACES.add("nt");
        PROTECTED_NAMESPACES.add("mix");
        PROTECTED_NAMESPACES.add("xml");
        PROTECTED_NAMESPACES.add("sv");
        PROTECTED_NAMESPACES.add("exo");
    }
}

