/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.proccess.WorkerThread;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

public final class SessionRegistry
implements Startable {
    private final Map<String, SessionImpl> sessionsMap = new WeakHashMap<String, SessionImpl>();
    public static final int DEFAULT_CLEANER_TIMEOUT = 60000;
    protected static Log log = ExoLogger.getLogger((String)"jcr.SessionRegistry");
    private SessionCleaner sessionCleaner;
    protected long timeOut;

    public SessionRegistry(RepositoryEntry entry) {
        if (entry != null) {
            this.timeOut = entry.getSessionTimeOut() > 0L ? entry.getSessionTimeOut() : 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSession(SessionImpl session) {
        Map<String, SessionImpl> map = this.sessionsMap;
        synchronized (map) {
            this.sessionsMap.put(session.getId(), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSession(String sessionId) {
        Map<String, SessionImpl> map = this.sessionsMap;
        synchronized (map) {
            this.sessionsMap.remove(sessionId);
        }
    }

    public SessionImpl getSession(String sessionId) {
        return this.sessionsMap.get(sessionId);
    }

    public boolean isInUse(String workspaceName) {
        if (workspaceName == null) {
            log.info((Object)("Session in use " + this.sessionsMap.size()));
            return this.sessionsMap.size() > 0;
        }
        for (SessionImpl session : this.sessionsMap.values()) {
            if (!session.getWorkspace().getName().equals(workspaceName)) continue;
            log.info((Object)("Session for workspace " + workspaceName + " in use." + " Session id:" + session.getId() + " user: " + session.getUserID()));
            return true;
        }
        return false;
    }

    public void start() {
        this.sessionsMap.clear();
        if (this.timeOut > 0L) {
            this.sessionCleaner = new SessionCleaner(60000L, this.timeOut);
        }
    }

    public void stop() {
        if (this.timeOut > 0L && this.sessionCleaner != null) {
            this.sessionCleaner.halt();
        }
        this.sessionsMap.clear();
    }

    private class SessionCleaner
    extends WorkerThread {
        private final long sessionTimeOut;

        public SessionCleaner(long workTime, long sessionTimeOut) {
            super(workTime);
            this.sessionTimeOut = sessionTimeOut;
            this.setName("SessionCleaner " + this.getId());
            this.setPriority(1);
            this.setDaemon(true);
            this.start();
            log.info((Object)("SessionCleaner instantiated name= " + this.getName() + " workTime= " + workTime + " sessionTimeOut=" + sessionTimeOut));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void callPeriodically() throws Exception {
            SessionImpl[] sessions;
            SessionImpl[] sessionImplArray = SessionRegistry.this.sessionsMap;
            synchronized (sessionImplArray) {
                sessions = new SessionImpl[SessionRegistry.this.sessionsMap.size()];
                SessionRegistry.this.sessionsMap.values().toArray(sessions);
            }
            sessionImplArray = sessions;
            synchronized (sessions) {
                for (int i = 0; i < sessions.length; ++i) {
                    if (sessions[i].getLastAccessTime() + this.sessionTimeOut >= System.currentTimeMillis()) continue;
                    sessions[i].logout();
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
    }
}

