/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionValue;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitions;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.value.NameValue;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeImpl
implements ExtendedNodeType {
    protected static final Value[] NULL_VALUES = new Value[]{null};
    protected static final String[] EMPTY_CONSTRAINTS = new String[0];
    protected boolean mixin;
    protected boolean orderableChild;
    protected String primaryItemName;
    protected NodeType[] declaredSupertypes;
    protected PropertyDefinition[] declaredPropertyDefinitions;
    protected NodeDefinition[] declaredChildNodeDefinitions;
    protected NodeTypeManagerImpl manager;
    protected InternalQName qName;

    protected NodeTypeImpl(NodeTypeManagerImpl manager) {
        this.manager = manager;
    }

    NodeTypeImpl(NodeTypeManagerImpl manager, NodeTypeValue value) throws NoSuchNodeTypeException, ConstraintViolationException, RepositoryException {
        this(manager);
        this.qName = manager.getLocationFactory().parseJCRName(value.getName()).getInternalName();
        this.mixin = value.isMixin();
        this.orderableChild = value.isOrderableChild();
        this.primaryItemName = value.getPrimaryItemName();
        List<String> supertypesList = value.getDeclaredSupertypeNames();
        this.declaredSupertypes = new NodeType[supertypesList.size()];
        for (int i = 0; i < supertypesList.size(); ++i) {
            this.declaredSupertypes[i] = manager.getNodeType(supertypesList.get(i));
        }
        List<PropertyDefinitionValue> declaredPropertyDefList = value.getDeclaredPropertyDefinitionValues();
        this.declaredPropertyDefinitions = new PropertyDefinition[declaredPropertyDefList.size()];
        for (int i = 0; i < declaredPropertyDefList.size(); ++i) {
            PropertyDefinitionValue p = declaredPropertyDefList.get(i);
            String[] constraints = null;
            if (p.getValueConstraints() != null) {
                constraints = new String[p.getValueConstraints().size()];
                for (int j = 0; j < p.getValueConstraints().size(); ++j) {
                    constraints[j] = p.getValueConstraints().get(j);
                }
            }
            Value[] defValues = null;
            if (p.getDefaultValueStrings() != null) {
                defValues = new Value[p.getDefaultValueStrings().size()];
                for (int j = 0; j < p.getDefaultValueStrings().size(); ++j) {
                    defValues[j] = manager.getValueFactory().createValue(p.getDefaultValueStrings().get(j), p.getRequiredType());
                }
            }
            InternalQName pdName = manager.getLocationFactory().parseJCRName(p.getName()).getInternalName();
            this.declaredPropertyDefinitions[i] = new PropertyDefinitionImpl(p.getName(), this, p.getRequiredType(), constraints, defValues, p.isAutoCreate(), p.isMandatory(), p.getOnVersion(), p.isReadOnly(), p.isMultiple(), pdName);
        }
        List<NodeDefinitionValue> declaredChildNodeDefList = value.getDeclaredChildNodeDefinitionValues();
        this.declaredChildNodeDefinitions = new NodeDefinition[declaredChildNodeDefList.size()];
        for (int i = 0; i < declaredChildNodeDefList.size(); ++i) {
            NodeDefinitionValue ndv = declaredChildNodeDefList.get(i);
            NodeType[] requiredTypes = new NodeType[ndv.getRequiredNodeTypeNames().size()];
            for (int j = 0; j < ndv.getRequiredNodeTypeNames().size(); ++j) {
                requiredTypes[j] = manager.getNodeType(ndv.getRequiredNodeTypeNames().get(j));
            }
            NodeTypeImpl nt = null;
            if (ndv.getDefaultNodeTypeName() != null) {
                nt = ndv.getDefaultNodeTypeName().equals(this.getName()) ? this : manager.getNodeType(ndv.getDefaultNodeTypeName());
            }
            InternalQName ndName = manager.getLocationFactory().parseJCRName(ndv.getName()).getInternalName();
            this.declaredChildNodeDefinitions[i] = new NodeDefinitionImpl(ndv.getName(), this, requiredTypes, nt, ndv.isAutoCreate(), ndv.isMandatory(), ndv.getOnVersion(), ndv.isReadOnly(), ndv.isSameNameSiblings(), ndName);
        }
    }

    public String getName() {
        String n;
        try {
            n = this.manager.getLocationFactory().createJCRName(this.qName).getAsString();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new RuntimeException("TYPE NAME >>> " + (Object)((Object)this.qName) + " " + (Object)((Object)e));
        }
        return n;
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChild;
    }

    public String getPrimaryItemName() {
        return this.primaryItemName;
    }

    public NodeType[] getSupertypes() {
        ArrayList<NodeType> stypesList = new ArrayList<NodeType>();
        this.fillSupertypes(stypesList, this);
        if (stypesList.size() > 0) {
            NodeType[] supertypes = new NodeType[stypesList.size()];
            for (int i = 0; i < stypesList.size(); ++i) {
                supertypes[i] = stypesList.get(i);
            }
            return supertypes;
        }
        return new NodeType[0];
    }

    public NodeType[] getDeclaredSupertypes() {
        if (this.declaredSupertypes != null) {
            return this.declaredSupertypes;
        }
        return new NodeType[0];
    }

    public boolean isNodeType(String nodeTypeName) {
        NodeType superType = null;
        try {
            superType = this.manager.getNodeType(nodeTypeName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(" NodeTypeImpl.isNodeType (" + superType + ") failed Reason:" + e);
        }
        return NodeTypeImpl.isSameOrSubType(superType, this);
    }

    @Override
    public boolean isNodeType(InternalQName nodeTypeQName) {
        ExtendedNodeType superType = null;
        try {
            superType = this.manager.getNodeType(nodeTypeQName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(" NodeTypeImpl.isNodeType (" + superType + ") failed Reason:" + e);
        }
        return NodeTypeImpl.isSameOrSubType(superType, this);
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        NodeType[] supertypes;
        LinkedHashSet<PropertyDefinition> propertyDefsList = new LinkedHashSet<PropertyDefinition>();
        if (this.declaredPropertyDefinitions != null) {
            for (int i = 0; i < this.declaredPropertyDefinitions.length; ++i) {
                propertyDefsList.add(this.declaredPropertyDefinitions[i]);
            }
        }
        if ((supertypes = this.getSupertypes()) != null) {
            for (int i = 0; i < supertypes.length; ++i) {
                if (supertypes[i].getDeclaredPropertyDefinitions() == null) continue;
                for (int j = 0; j < supertypes[i].getDeclaredPropertyDefinitions().length; ++j) {
                    if (propertyDefsList.contains(supertypes[i].getDeclaredPropertyDefinitions()[j])) continue;
                    propertyDefsList.add(supertypes[i].getDeclaredPropertyDefinitions()[j]);
                }
            }
        }
        if (propertyDefsList.size() > 0) {
            PropertyDefinition[] propertyDefs = new PropertyDefinition[propertyDefsList.size()];
            return propertyDefsList.toArray(propertyDefs);
        }
        return new PropertyDefinition[0];
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        if (this.declaredPropertyDefinitions != null) {
            return this.declaredPropertyDefinitions;
        }
        return new PropertyDefinition[0];
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        NodeType[] supertypes;
        ArrayList<NodeDefinition> nodeDefsList = new ArrayList<NodeDefinition>();
        if (this.declaredChildNodeDefinitions != null) {
            for (int i = 0; i < this.declaredChildNodeDefinitions.length; ++i) {
                nodeDefsList.add(this.declaredChildNodeDefinitions[i]);
            }
        }
        if ((supertypes = this.getSupertypes()) != null) {
            for (int i = 0; i < supertypes.length; ++i) {
                if (supertypes[i].getDeclaredChildNodeDefinitions() == null) continue;
                for (int j = 0; j < supertypes[i].getDeclaredChildNodeDefinitions().length; ++j) {
                    if (nodeDefsList.contains(supertypes[i].getDeclaredChildNodeDefinitions()[j])) continue;
                    nodeDefsList.add(supertypes[i].getDeclaredChildNodeDefinitions()[j]);
                }
            }
        }
        if (nodeDefsList.size() > 0) {
            NodeDefinition[] childNodeDefs = new NodeDefinition[nodeDefsList.size()];
            for (int i = 0; i < nodeDefsList.size(); ++i) {
                childNodeDefs[i] = (NodeDefinition)nodeDefsList.get(i);
            }
            return childNodeDefs;
        }
        return new NodeDefinition[0];
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        if (this.declaredChildNodeDefinitions != null) {
            return this.declaredChildNodeDefinitions;
        }
        return new NodeDefinition[0];
    }

    public boolean canSetProperty(String propertyName, Value value) {
        PropertyDefinition def = this.getPropertyDefinitions(propertyName).getDefinition(false);
        if (def != null) {
            if (def.isProtected()) {
                return false;
            }
            int requiredType = def.getRequiredType();
            return this.canSetPropertyForType(requiredType, propertyName, value, def.getValueConstraints());
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private boolean canSetPropertyForType(int requiredType, String propertyName, Value value, String[] constrains) {
        if (value == null) {
            return this.canRemoveItem(propertyName);
        }
        if (requiredType == value.getType()) {
            return this.checkValueConstraints(constrains, value);
        }
        if (requiredType == 2 && (value.getType() == 1 || value.getType() == 5 || value.getType() == 3 || value.getType() == 4 || value.getType() == 7 || value.getType() == 8 || value.getType() == 6)) {
            return this.checkValueConstraints(constrains, value);
        }
        if (requiredType == 6) {
            if (value.getType() == 1) {
                return this.checkValueConstraints(constrains, value);
            }
            if (value.getType() == 2) {
                try {
                    return this.isCharsetString(value.getString(), "UTF-8") && this.checkValueConstraints(constrains, value);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        if (requiredType == 5) {
            String likeDataString = null;
            try {
                if (value.getType() == 1) {
                    likeDataString = value.getString();
                } else if (value.getType() == 2) {
                    likeDataString = this.getCharsetString(value.getString(), "UTF-8");
                } else {
                    if (value.getType() == 4 || value.getType() == 3) {
                        return this.checkValueConstraints(constrains, value);
                    }
                    return false;
                }
                Calendar calDate = JCRDateFormat.parse(likeDataString);
                return this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 4) {
            String likeDoubleString = null;
            try {
                if (value.getType() == 1) {
                    likeDoubleString = value.getString();
                } else if (value.getType() == 2) {
                    likeDoubleString = this.getCharsetString(value.getString(), "UTF-8");
                } else {
                    if (value.getType() == 3) {
                        return this.checkValueConstraints(constrains, value);
                    }
                    return false;
                }
                Double doubleValue = new Double(likeDoubleString);
                return doubleValue != null && this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 3) {
            String likeLongString = null;
            try {
                if (value.getType() == 1) {
                    likeLongString = value.getString();
                } else if (value.getType() == 2) {
                    likeLongString = this.getCharsetString(value.getString(), "UTF-8");
                } else {
                    if (value.getType() == 5) {
                        return true;
                    }
                    return value.getType() == 4;
                }
                Long longValue = new Long(likeLongString);
                return longValue != null && this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 7) {
            String likeNameString;
            block52: {
                likeNameString = null;
                if (value.getType() == 1) {
                    likeNameString = value.getString();
                    break block52;
                }
                if (value.getType() == 2) {
                    likeNameString = this.getCharsetString(value.getString(), "UTF-8");
                    break block52;
                }
                if (value.getType() == 8) {
                    String pathString = value.getString();
                    String[] pathParts = pathString.split("\\/");
                    if (pathString.startsWith("/") && (pathParts.length > 1 || pathString.indexOf("[") > 0)) {
                        return false;
                    }
                    if (!pathParts.equals("/") && pathParts.length == 1 && pathString.indexOf("[") < 0) {
                        return this.checkValueConstraints(constrains, value);
                    }
                    if (pathString.startsWith("/") && pathString.lastIndexOf("/") < 1 && pathString.indexOf("[") < 0) {
                        return this.checkValueConstraints(constrains, value);
                    }
                    return false;
                }
                return false;
                {
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            try {
                Value nameValue = this.manager.getValueFactory().createValue(likeNameString, 7);
                return nameValue != null && this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 1) {
            String likeStringString = null;
            try {
                if (value.getType() == 2) {
                    likeStringString = this.getCharsetString(value.getString(), "UTF-8");
                } else if (value.getType() == 5 || value.getType() == 3 || value.getType() == 6 || value.getType() == 7 || value.getType() == 8 || value.getType() == 4) {
                    likeStringString = value.getString();
                } else {
                    return false;
                }
                return likeStringString != null && this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 0) {
            return this.checkValueConstraints(constrains, value);
        }
        return false;
    }

    private String getCharsetString(String source, String charSetName) {
        try {
            CharBuffer cb = CharBuffer.wrap(source.toCharArray());
            Charset cs = Charset.forName(charSetName);
            CharsetEncoder cse = cs.newEncoder();
            ByteBuffer encoded = cse.encode(cb);
            return new String(encoded.array()).trim();
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (MalformedInputException e) {
            return null;
        }
        catch (UnmappableCharacterException e) {
            return null;
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    private boolean isCharsetString(String source, String charSetName) {
        try {
            String s = this.getCharsetString(source, charSetName);
            return s != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        PropertyDefinition def = this.getPropertyDefinitions(propertyName).getDefinition(true);
        if (def != null) {
            if (def.isProtected()) {
                return false;
            }
            if (values != null) {
                int requiredType = def.getRequiredType();
                if (values.length > 0) {
                    int res = 0;
                    for (int i = 0; i < values.length; ++i) {
                        try {
                            if (!this.canSetPropertyForType(requiredType, propertyName, values[i], def.getValueConstraints())) continue;
                            ++res;
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return res == values.length;
                }
                return true;
            }
            return this.canRemoveItem(propertyName);
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName) {
        NodeDefinition childNodeDef = this.getChildNodeDefinition(childNodeName);
        return childNodeDef != null && !childNodeDef.isProtected() && childNodeDef.getDefaultPrimaryType() != null;
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        NodeDefinition childNodeDef = this.getChildNodeDefinition(childNodeName);
        return childNodeDef != null && !childNodeDef.isProtected() && this.isChildNodePrimaryTypeAllowed(nodeTypeName);
    }

    public boolean canRemoveItem(String itemName) {
        PropertyDefinition propDef = this.getPropertyDefinitions(itemName).getAnyDefinition();
        if (propDef != null) {
            return !propDef.isMandatory() && !propDef.isProtected();
        }
        NodeDefinition nodeDef = this.getChildNodeDefinition(itemName);
        if (nodeDef != null) {
            return !nodeDef.isMandatory() && !nodeDef.isProtected();
        }
        return false;
    }

    @Override
    public PropertyDefinitions getPropertyDefinitions(String name) {
        PropertyDefinitions defs = new PropertyDefinitions();
        for (int i = 0; i < this.getPropertyDefinitions().length; ++i) {
            PropertyDefinitionImpl propDef = (PropertyDefinitionImpl)this.getPropertyDefinitions()[i];
            if (!propDef.getName().equals(name) && !propDef.isResidualSet()) continue;
            defs.setDefinition(propDef);
        }
        return defs;
    }

    @Override
    public NodeDefinition getChildNodeDefinition(String name) {
        NodeDefinition residual = null;
        for (int i = 0; i < this.getChildNodeDefinitions().length; ++i) {
            NodeDefinition nodeDef = this.getChildNodeDefinitions()[i];
            if (nodeDef.getName().equals(name)) {
                return nodeDef;
            }
            if (!nodeDef.getName().equals("*")) continue;
            residual = nodeDef;
        }
        return residual;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExtendedNodeType) {
            return this.qName.equals((Object)((ExtendedNodeType)obj).getQName());
        }
        return false;
    }

    protected boolean checkValueConstraints(String[] constraints, Value value) {
        if (constraints != null && constraints.length > 0) {
            for (int i = 0; i < constraints.length; ++i) {
                try {
                    if (!constraints[i].equals(value.getString())) continue;
                    return true;
                }
                catch (RepositoryException e) {
                    System.err.println("Error! Can't get value's string value: " + (Object)((Object)e));
                }
            }
        } else {
            return true;
        }
        return false;
    }

    protected void fillSupertypes(List<NodeType> list, NodeType subtype) {
        if (subtype.getDeclaredSupertypes() != null) {
            for (int i = 0; i < subtype.getDeclaredSupertypes().length; ++i) {
                list.add(subtype.getDeclaredSupertypes()[i]);
                this.fillSupertypes(list, subtype.getDeclaredSupertypes()[i]);
            }
        }
    }

    public static boolean isSameOrSubType(NodeType superType, NodeType subType) {
        if (superType.equals(subType)) {
            return true;
        }
        NodeType[] superTypes = subType.getSupertypes();
        for (int j = 0; j < superTypes.length; ++j) {
            NodeType testSuperType = superTypes[j];
            if (!testSuperType.equals(superType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<ItemDefinition> getManadatoryItemDefs() {
        int i;
        ArrayList<ItemDefinition> itemDefs = new ArrayList<ItemDefinition>();
        for (i = 0; i < this.getPropertyDefinitions().length; ++i) {
            if (!this.getPropertyDefinitions()[i].isMandatory()) continue;
            itemDefs.add((ItemDefinition)this.getPropertyDefinitions()[i]);
        }
        for (i = 0; i < this.getChildNodeDefinitions().length; ++i) {
            if (!this.getChildNodeDefinitions()[i].isMandatory()) continue;
            itemDefs.add((ItemDefinition)this.getChildNodeDefinitions()[i]);
        }
        return itemDefs;
    }

    @Override
    public boolean isChildNodePrimaryTypeAllowed(String typeName) {
        NodeType testType;
        NodeDefinition[] definitions = this.getChildNodeDefinitions();
        try {
            testType = this.manager.getNodeType(typeName);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Error " + (Object)((Object)e));
        }
        for (int i = 0; i < definitions.length; ++i) {
            NodeType[] requiredTypes = definitions[i].getRequiredPrimaryTypes();
            for (int j = 0; j < requiredTypes.length; ++j) {
                if (requiredTypes[j].equals(testType)) {
                    return true;
                }
                NodeType[] testSuperTypes = testType.getSupertypes();
                for (int k = 0; k < testSuperTypes.length; ++k) {
                    if (!testSuperTypes[k].equals(requiredTypes[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void setMixin(boolean mixin) {
        this.mixin = mixin;
    }

    @Override
    public void setName(String name) throws RepositoryException {
        this.qName = ((NameValue)this.manager.getValueFactory().createValue(name, 7)).getQName();
    }

    @Override
    public void setOrderableChild(boolean orderableChild) {
        this.orderableChild = orderableChild;
    }

    @Override
    public void setPrimaryItemName(String primaryItemName) {
        this.primaryItemName = primaryItemName;
    }

    @Override
    public void setDeclaredNodeDefs(NodeDefinition[] declaredNodeDefs) {
        this.declaredChildNodeDefinitions = declaredNodeDefs;
    }

    @Override
    public void setDeclaredPropertyDefs(PropertyDefinition[] declaredPropertyDefs) {
        this.declaredPropertyDefinitions = declaredPropertyDefs;
    }

    @Override
    public void setDeclaredSupertypes(NodeType[] declaredSupertypes) {
        this.declaredSupertypes = declaredSupertypes;
    }

    @Override
    public InternalQName getQName() {
        return this.qName;
    }

    @Override
    public PropertyDefinitions getPropertyDefinitions(InternalQName name) {
        PropertyDefinitions defs = new PropertyDefinitions();
        for (int i = 0; i < this.getPropertyDefinitions().length; ++i) {
            PropertyDefinitionImpl propDef = (PropertyDefinitionImpl)this.getPropertyDefinitions()[i];
            if (!propDef.getQName().equals((Object)name) && !propDef.isResidualSet()) continue;
            defs.setDefinition(propDef);
        }
        return defs;
    }

    @Override
    public NodeDefinition getChildNodeDefinition(InternalQName name) {
        NodeDefinitionImpl residual = null;
        for (int i = 0; i < this.getChildNodeDefinitions().length; ++i) {
            NodeDefinitionImpl nodeDef = (NodeDefinitionImpl)this.getChildNodeDefinitions()[i];
            if (nodeDef.getQName().equals((Object)name)) {
                return nodeDef;
            }
            if (!nodeDef.getName().equals("*")) continue;
            residual = nodeDef;
        }
        return residual;
    }
}

