/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import javax.jcr.query.InvalidQueryException;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.sql.JCRSQLQueryBuilder;
import org.exoplatform.services.jcr.impl.core.query.xpath.XPathQueryBuilder;

public class QueryParser {
    private QueryParser() {
    }

    public static QueryRootNode parse(String statement, String language, LocationFactory locationFactory) throws InvalidQueryException {
        if ("xpath".equals(language)) {
            return XPathQueryBuilder.createQuery(statement, locationFactory);
        }
        if ("sql".equals(language)) {
            return JCRSQLQueryBuilder.createQuery(statement, locationFactory);
        }
        throw new InvalidQueryException("Unsupported language: " + language);
    }

    public static String toString(QueryRootNode root, String language, LocationFactory locationFactory) throws InvalidQueryException {
        if ("xpath".equals(language)) {
            return XPathQueryBuilder.toString(root, locationFactory);
        }
        if ("sql".equals(language)) {
            return JCRSQLQueryBuilder.toString(root, locationFactory);
        }
        throw new InvalidQueryException("Unsupported language: " + language);
    }
}

