/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;

class DerefQuery
extends Query {
    private final Query contextQuery;
    private final String refProperty;
    private final String nameTest;
    private Scorer contextScorer;
    private Scorer nameTestScorer;

    DerefQuery(Query context, String refProperty, String nameTest) {
        this.contextQuery = context;
        this.refProperty = refProperty;
        this.nameTest = nameTest;
    }

    protected Weight createWeight(Searcher searcher) {
        return new DerefWeight(searcher);
    }

    public String toString(String field) {
        return "DerefQuery";
    }

    private class DerefScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet hits;
        private List identifiers;
        private int nextDoc;

        protected DerefScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.identifiers = null;
            this.nextDoc = -1;
            this.reader = reader;
            this.hits = new BitSet(reader.maxDoc());
        }

        public boolean next() throws IOException {
            this.calculateChildren();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        public int doc() {
            return this.nextDoc;
        }

        public float score() throws IOException {
            return 1.0f;
        }

        public boolean skipTo(int target) throws IOException {
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateChildren() throws IOException {
            if (this.identifiers == null) {
                this.identifiers = new ArrayList();
                DerefQuery.this.contextScorer.score(new HitCollector(){

                    public void collect(int doc, float score) {
                        DerefScorer.this.hits.set(doc);
                    }
                });
                final BitSet nameTestHits = new BitSet();
                if (DerefQuery.this.nameTestScorer != null) {
                    DerefQuery.this.nameTestScorer.score(new HitCollector(){

                        public void collect(int doc, float score) {
                            nameTestHits.set(doc);
                        }
                    });
                }
                int i = this.hits.nextSetBit(0);
                while (i >= 0) {
                    Document doc = this.reader.document(i);
                    String[] values = doc.getValues(FieldNames.PROPERTIES);
                    String prefix = FieldNames.createNamedValue(DerefQuery.this.refProperty, "");
                    for (int v = 0; v < values.length; ++v) {
                        if (!values[v].startsWith(prefix)) continue;
                        this.identifiers.add(values[v].substring(prefix.length()));
                    }
                    i = this.hits.nextSetBit(i + 1);
                }
                this.hits.clear();
                Iterator it = this.identifiers.iterator();
                while (it.hasNext()) {
                    TermDocs node = this.reader.termDocs(new Term(FieldNames.UUID, (String)it.next()));
                    try {
                        while (node.next()) {
                            this.hits.set(node.doc());
                        }
                    }
                    finally {
                        node.close();
                    }
                }
                if (DerefQuery.this.nameTestScorer != null) {
                    this.hits.and(nameTestHits);
                }
            }
        }
    }

    private class DerefWeight
    implements Weight {
        private final Searcher searcher;

        private DerefWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return DerefQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            DerefQuery.this.contextScorer = DerefQuery.this.contextQuery.weight(this.searcher).scorer(reader);
            if (DerefQuery.this.nameTest != null) {
                DerefQuery.this.nameTestScorer = new TermQuery(new Term(FieldNames.LABEL, DerefQuery.this.nameTest)).weight(this.searcher).scorer(reader);
            }
            return new DerefScorer(this.searcher.getSimilarity(), reader);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

